/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.tileentity.ITileEntityRotateable;
import com.xcompwiz.mystcraft.tileentity.TileEntityBook;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityBookRotateable
extends TileEntityBook
implements ITileEntityRotateable {
    private short yaw = 0;
    private short pitch = 0;

    public void setPitch(int pitch) {
        this.pitch = (short)(pitch % 360);
        this.markForUpdate();
    }

    public short getPitch() {
        return this.pitch;
    }

    @Override
    public void setYaw(int yaw) {
        this.yaw = (short)(yaw % 360);
        this.markForUpdate();
    }

    @Override
    public short getYaw() {
        return this.yaw;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.setYaw(NBTUtils.readNumber((NBTBase)compound.func_74775_l("Yaw")).intValue());
        this.setPitch(NBTUtils.readNumber((NBTBase)compound.func_74775_l("Pitch")).intValue());
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74777_a("Yaw", this.yaw);
        compound.func_74777_a("Pitch", this.pitch);
    }

    public void link(Entity player) {
        ItemStack book = this.getBook();
        if (book.func_190926_b()) {
            return;
        }
        if (!(book.func_77973_b() instanceof ItemLinking)) {
            return;
        }
        ((ItemLinking)book.func_77973_b()).activate(book, this.field_145850_b, player);
    }
}

