/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.tileentity;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.impl.InternalAPI;
import com.xcompwiz.mystcraft.api.item.IItemOrderablePageProvider;
import com.xcompwiz.mystcraft.api.item.IItemPageAcceptor;
import com.xcompwiz.mystcraft.api.item.IItemPageCollection;
import com.xcompwiz.mystcraft.api.item.IItemPageProvider;
import com.xcompwiz.mystcraft.api.item.IItemRenameable;
import com.xcompwiz.mystcraft.api.item.IItemWritable;
import com.xcompwiz.mystcraft.block.BlockWritingDesk;
import com.xcompwiz.mystcraft.data.ModAchievements;
import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.fluids.FluidUtils;
import com.xcompwiz.mystcraft.item.ItemLinking;
import com.xcompwiz.mystcraft.item.ItemPage;
import com.xcompwiz.mystcraft.tileentity.FluidTankFiltered;
import com.xcompwiz.mystcraft.tileentity.IOInventory;
import com.xcompwiz.mystcraft.tileentity.InventoryFilter;
import com.xcompwiz.mystcraft.tileentity.TileEntityBase;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityDesk
extends TileEntityBase
implements InventoryFilter,
ITickable {
    private IOInventory inventoryStacks;
    private IOInventory inventoryTabItems;
    private FluidTankFiltered inkwell = new FluidTankFiltered(1000);
    private static final int slot_wrt = 0;
    private static final int slot_pap = 1;
    private static final int slot_ctn = 2;
    private static final int slot_out = 3;

    public TileEntityDesk() {
        this.inkwell.setPermittedFluids(Mystcraft.validInks);
        this.inventoryStacks = this.buildWorkInventory();
        this.inventoryTabItems = this.buildTabInventory();
    }

    protected IOInventory buildWorkInventory() {
        return new IOInventory(this, new int[]{1}, new int[0], EnumFacing.field_82609_l).setMiscSlots(0, 2, 3).setListener(() -> this.onChange(true)).applyFilter(this, 1);
    }

    protected IOInventory buildTabInventory() {
        IOInventory inv = new IOInventory(this, new int[0], new int[0], EnumFacing.field_82609_l).setListener(() -> this.onChange(false));
        int i = 0;
        while (i < 25) {
            inv.setMiscSlots(i++);
        }
        return inv;
    }

    public int getMainInventorySize() {
        return this.inventoryStacks.getSlots();
    }

    public int getMaxSurfaceTabCount() {
        return this.inventoryTabItems.getSlots();
    }

    public int getPaperCount() {
        ItemStack itemstack = this.inventoryStacks.getStackInSlot(1);
        if (!itemstack.func_190926_b()) {
            return itemstack.func_190916_E();
        }
        return 0;
    }

    @Nonnull
    public ItemStack getDisplayItem() {
        return this.inventoryStacks.getStackInSlot(0);
    }

    @Nonnull
    public ItemStack getTabItem(byte activeslot) {
        if (activeslot < 0 || activeslot >= this.inventoryTabItems.getSlots()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = this.inventoryTabItems.getStackInSlot(activeslot);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (itemstack.func_77973_b() instanceof IItemPageCollection) {
            return itemstack;
        }
        if (itemstack.func_77973_b() instanceof IItemWritable) {
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public void onChange(boolean isWorkInv) {
        if (isWorkInv) {
            for (int i = 0; i < this.inventoryStacks.getSlots(); ++i) {
                this.handleItemChange(this.inventoryStacks.getStackInSlot(i));
            }
        } else {
            for (int i = 0; i < this.inventoryTabItems.getSlots(); ++i) {
                this.handleItemChange(this.inventoryTabItems.getStackInSlot(i));
            }
        }
    }

    @Override
    public boolean canAcceptItem(int slot, @Nonnull ItemStack stack) {
        FluidStack fluidStack;
        if (stack.func_190926_b()) {
            return false;
        }
        if (slot == 0 && stack.func_190916_E() == 1 && stack.func_77973_b() instanceof IItemWritable) {
            return true;
        }
        if (slot == 0 && stack.func_190916_E() == 1 && stack.func_77973_b() instanceof IItemRenameable) {
            return true;
        }
        if (slot == 0 && stack.func_190916_E() == 1 && stack.func_77973_b() instanceof IItemPageAcceptor) {
            return true;
        }
        if (slot == 1 && stack.func_77973_b().equals(Items.field_151121_aF)) {
            return true;
        }
        if (slot == 2 && (fluidStack = FluidUtil.getFluidContained((ItemStack)stack)) != null) {
            return this.inkwell.isFluidPermitted(fluidStack.getFluid());
        }
        if ((slot -= this.inventoryStacks.getSlots()) < 0) {
            return false;
        }
        if (slot >= this.inventoryTabItems.getSlots()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IItemPageCollection) {
            return true;
        }
        return stack.func_77973_b() instanceof IItemWritable;
    }

    public boolean hasTop() {
        if (!this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()).func_177230_c().equals(ModBlocks.writingdesk)) {
            return false;
        }
        return BlockWritingDesk.isBlockTop(this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a()));
    }

    public boolean isLeftCovered() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
        if (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a()) && !state.func_177230_c().equals(ModBlocks.writingdesk)) {
            return true;
        }
        return !BlockWritingDesk.isBlockTop(state);
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.inkwell.readFromNBT(compound.func_74775_l("fluid"));
        this.inventoryStacks.readNBT(compound.func_74775_l("items"));
        this.inventoryTabItems.readNBT(compound.func_74775_l("notebooks"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        NBTTagCompound tag = new NBTTagCompound();
        this.inkwell.writeToNBT(tag);
        compound.func_74782_a("fluid", (NBTBase)tag);
        compound.func_74782_a("items", (NBTBase)this.inventoryStacks.writeNBT());
        compound.func_74782_a("notebooks", (NBTBase)this.inventoryTabItems.writeNBT());
    }

    public void handleItemChange(@Nonnull ItemStack itemstack) {
    }

    @Nonnull
    public String getTargetString(EntityPlayer player) {
        ItemStack itemstack = this.inventoryStacks.getStackInSlot(0);
        if (itemstack.func_190926_b()) {
            return "";
        }
        if (!(itemstack.func_77973_b() instanceof IItemRenameable)) {
            return "";
        }
        String name = ((IItemRenameable)itemstack.func_77973_b()).getDisplayName(player, itemstack);
        if (name == null) {
            return "";
        }
        return name;
    }

    public void setBookTitle(EntityPlayer player, String bookname) {
        ItemStack itemstack = this.inventoryStacks.getStackInSlot(0);
        if (itemstack.func_190926_b()) {
            return;
        }
        if (!(itemstack.func_77973_b() instanceof IItemRenameable)) {
            return;
        }
        ((IItemRenameable)itemstack.func_77973_b()).setDisplayName(player, itemstack, bookname);
    }

    @Nullable
    public List<ItemStack> getBookPageList(EntityPlayer player) {
        ItemStack itemstack = this.inventoryStacks.getStackInSlot(0);
        if (itemstack.func_190926_b()) {
            return null;
        }
        if (!(itemstack.func_77973_b() instanceof IItemPageProvider)) {
            return null;
        }
        return ((IItemPageProvider)itemstack.func_77973_b()).getPageList(player, itemstack);
    }

    public void writeSymbol(EntityPlayer player, ResourceLocation symbol2) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.hasEnoughInk()) {
            return;
        }
        if (this.inventoryStacks.getStackInSlot(0).func_190926_b() && !this.inventoryStacks.getStackInSlot(1).func_190926_b()) {
            this.inventoryStacks.setStackInSlot(0, ItemPage.createItemstack(this.inventoryStacks.getStackInSlot(1)));
            if (this.inventoryStacks.getStackInSlot(1).func_190916_E() <= 0) {
                this.inventoryStacks.setStackInSlot(1, ItemStack.field_190927_a);
            }
        }
        if (this.inventoryStacks.getStackInSlot(0).func_190926_b()) {
            return;
        }
        ItemStack target = this.inventoryStacks.getStackInSlot(0);
        if (target.func_190926_b()) {
            return;
        }
        if (target.func_77973_b() instanceof IItemWritable && ((IItemWritable)target.func_77973_b()).writeSymbol(player, target, symbol2)) {
            this.useink();
            if (player instanceof EntityPlayerMP) {
                ModAchievements.TRIGGER_WRITE.trigger((EntityPlayerMP)player);
            }
            return;
        }
        ItemStack paperstack = this.inventoryStacks.getStackInSlot(1);
        if (!paperstack.func_190926_b() && target.func_77973_b() instanceof IItemPageAcceptor) {
            ItemStack page = paperstack.func_77946_l();
            page.func_190920_e(1);
            page = ItemPage.createItemstack(page);
            if (!page.func_190926_b()) {
                InternalAPI.page.setPageSymbol(page, symbol2);
                if (((IItemPageAcceptor)target.func_77973_b()).addPage(player, target, page).func_190926_b()) {
                    this.useink();
                    paperstack.func_190918_g(1);
                    if (player instanceof EntityPlayerMP) {
                        ModAchievements.TRIGGER_WRITE.trigger((EntityPlayerMP)player);
                    }
                }
            }
            if (this.inventoryStacks.getStackInSlot(1).func_190916_E() <= 0) {
                this.inventoryStacks.setStackInSlot(1, ItemStack.field_190927_a);
            }
        }
    }

    @Nonnull
    public ItemStack removePageFromSurface(EntityPlayer player, @Nonnull ItemStack itemstack, int index) {
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ItemStack.field_190927_a;
        if (itemstack.func_77973_b() instanceof IItemOrderablePageProvider) {
            result = ((IItemOrderablePageProvider)itemstack.func_77973_b()).removePage(player, itemstack, index);
        }
        if (result.func_190926_b()) {
            return result;
        }
        this.markForUpdate();
        return result;
    }

    @Nonnull
    public ItemStack removePageFromSurface(EntityPlayer player, @Nonnull ItemStack itemstack, @Nonnull ItemStack page) {
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = ItemStack.field_190927_a;
        if (itemstack.func_77973_b() instanceof IItemPageCollection) {
            result = ((IItemPageCollection)itemstack.func_77973_b()).remove(player, itemstack, page);
        }
        if (result.func_190926_b()) {
            return result;
        }
        this.markForUpdate();
        return result;
    }

    @Nonnull
    public ItemStack addPageToTab(EntityPlayer player, @Nonnull ItemStack itemstack, @Nonnull ItemStack page) {
        if (itemstack.func_190926_b()) {
            return page;
        }
        ItemStack result = page;
        if (itemstack.func_77973_b() instanceof IItemPageAcceptor) {
            result = ((IItemPageAcceptor)itemstack.func_77973_b()).addPage(player, itemstack, page);
        }
        if (result == page) {
            return result;
        }
        this.markForUpdate();
        return result;
    }

    @Nonnull
    public ItemStack placePageOnSurface(EntityPlayer player, @Nonnull ItemStack itemstack, @Nonnull ItemStack page, int index) {
        if (itemstack.func_190926_b()) {
            return page;
        }
        ItemStack result = page;
        if (itemstack.func_77973_b() instanceof IItemOrderablePageProvider) {
            result = ((IItemOrderablePageProvider)itemstack.func_77973_b()).setPage(player, itemstack, page, index);
        } else if (itemstack.func_77973_b() instanceof IItemPageCollection) {
            result = ((IItemPageCollection)itemstack.func_77973_b()).addPage(player, itemstack, page);
        }
        if (result == page) {
            return result;
        }
        this.markForUpdate();
        return result;
    }

    @Nonnull
    public ItemStack getTarget() {
        return this.inventoryStacks.getStackInSlot(0);
    }

    @Nullable
    public FluidStack getInk() {
        return this.inkwell.getFluid();
    }

    public void setInk(@Nullable FluidStack fluid) {
        this.inkwell.setFluid(fluid);
    }

    private boolean hasEnoughInk() {
        FluidStack fluid = this.inkwell.getFluid();
        return fluid != null && fluid.amount >= Mystcraft.inkcost;
    }

    private void useink() {
        this.inkwell.drain(Mystcraft.inkcost, true);
    }

    public void func_73660_a() {
        ItemStack container;
        FluidActionResult far;
        ItemStack result;
        ItemStack fluidContainer;
        ItemStack emptyContainer;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (BlockWritingDesk.isBlockFoot(this.field_145850_b.func_180495_p(this.field_174879_c))) {
            this.field_145846_f = true;
        }
        if (!(this.inventoryStacks.getStackInSlot(2).func_190926_b() || !(emptyContainer = (fluidContainer = this.inventoryStacks.getStackInSlot(2)).func_77973_b().getContainerItem(fluidContainer)).func_190926_b() && TileEntityDesk.mergeItemStacksLeft(this.inventoryStacks.getStackInSlot(3), emptyContainer) == this.inventoryStacks.getStackInSlot(3) || (result = FluidUtils.fillTankWithContainer((IFluidTank)this.inkwell, fluidContainer)).func_190926_b())) {
            this.inventoryStacks.setStackInSlot(3, TileEntityDesk.mergeItemStacksLeft(this.inventoryStacks.getStackInSlot(3), result));
            if (fluidContainer.func_190916_E() <= 0) {
                this.inventoryStacks.setStackInSlot(2, ItemStack.field_190927_a);
            }
        }
        if (!this.inventoryStacks.getStackInSlot(2).func_190926_b() && (far = FluidUtil.tryFillContainer((ItemStack)(container = this.inventoryStacks.getStackInSlot(2)), (IFluidHandler)this.inkwell, (int)1000, null, (boolean)false)).isSuccess() && TileEntityDesk.mergeItemStacksLeft(this.inventoryStacks.getStackInSlot(3), far.getResult()) != this.inventoryStacks.getStackInSlot(3)) {
            this.inventoryStacks.setStackInSlot(3, TileEntityDesk.mergeItemStacksLeft(this.inventoryStacks.getStackInSlot(3), FluidUtil.tryFillContainer((ItemStack)container, (IFluidHandler)this.inkwell, (int)1000, null, (boolean)true).getResult()));
            if (container.func_190916_E() <= 0) {
                this.inventoryStacks.setStackInSlot(2, ItemStack.field_190927_a);
            }
        }
    }

    @Nonnull
    private static ItemStack mergeItemStacksLeft(@Nonnull ItemStack left, @Nonnull ItemStack right) {
        if (right.func_190926_b()) {
            return left;
        }
        if (left.func_190926_b()) {
            return right;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return left;
        }
        if (left.func_77942_o() != right.func_77942_o()) {
            return left;
        }
        if (left.func_77942_o() && !left.func_77978_p().equals((Object)right.func_77978_p())) {
            return left;
        }
        if (left.func_77973_b().func_77614_k() && left.func_77952_i() != right.func_77952_i()) {
            return left;
        }
        if (left.func_190916_E() + right.func_190916_E() > left.func_77976_d()) {
            return left;
        }
        left = left.func_77946_l();
        left.func_190917_f(right.func_190916_E());
        right.func_190920_e(0);
        return left;
    }

    public void link(Entity player) {
        ItemStack book = this.getTarget();
        if (book.func_190926_b()) {
            return;
        }
        if (!(book.func_77973_b() instanceof ItemLinking)) {
            return;
        }
        ((ItemLinking)book.func_77973_b()).activate(book, this.field_145850_b, player);
    }

    public IOInventory getMainItemHandler() {
        return this.inventoryStacks;
    }

    public IOInventory getTabsItemHandler() {
        return this.inventoryTabItems;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventoryStacks.getCapability(facing);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this.inkwell);
        }
        return null;
    }

    public FluidTankFiltered getInkwell() {
        return this.inkwell;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(-1.0, 0.0, -1.0, 2.0, 2.0, 2.0).func_186670_a(this.field_174879_c);
    }
}

