/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.agedata;

import com.xcompwiz.mystcraft.Mystcraft;
import com.xcompwiz.mystcraft.api.world.storage.StorageObject;
import com.xcompwiz.mystcraft.data.GrammarRules;
import com.xcompwiz.mystcraft.debug.DebugFlags;
import com.xcompwiz.mystcraft.grammar.GrammarTree;
import com.xcompwiz.mystcraft.nbt.NBTTagCompoundWrapper;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import com.xcompwiz.mystcraft.page.Page;
import com.xcompwiz.mystcraft.symbol.SymbolRemappings;
import com.xcompwiz.mystcraft.world.agedata.AgeDataLoaderManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class AgeData
extends WorldSavedData {
    private String agename;
    private Set<String> authors;
    private long seed;
    private UUID uuid;
    private short instability;
    private boolean instabilityEnabled;
    private long worldtime;
    private BlockPos spawn;
    private List<ItemStack> pages = new ArrayList<ItemStack>();
    private List<ResourceLocation> symbols = new ArrayList<ResourceLocation>();
    private boolean visited;
    private boolean dead;
    private NBTTagCompound datacompound;
    public Map<String, NBTBase> cruft = new HashMap<String, NBTBase>();
    private boolean updated;
    private Boolean sharedDirty = Boolean.FALSE;
    private boolean needsResend;
    private Boolean sharedResend = Boolean.FALSE;

    public AgeData(String s) {
        super(s);
        this.datacompound = new NBTTagCompound();
    }

    public boolean func_76188_b() {
        if (this.sharedDirty.booleanValue()) {
            return true;
        }
        return super.func_76188_b();
    }

    public void func_76186_a(boolean par1) {
        super.func_76186_a(par1);
        if (!par1) {
            this.sharedDirty = false;
        }
    }

    public boolean needsResend() {
        if (this.sharedResend.booleanValue()) {
            return true;
        }
        return this.needsResend;
    }

    public void resent() {
        this.needsResend = false;
        this.sharedResend = false;
    }

    public void markNeedsResend() {
        this.needsResend = true;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void markVisited() {
        if (!this.visited) {
            this.func_76185_a();
        }
        this.visited = true;
        this.updated = false;
    }

    public boolean isDead() {
        return this.dead;
    }

    public void markDead() {
        this.dead = true;
    }

    public void onConstruct() {
        this.updated = false;
    }

    public void setAgeName(String name) {
        this.agename = name;
        this.func_76185_a();
    }

    public String getAgeName() {
        return this.agename;
    }

    public Set<String> getAuthors() {
        if (this.authors == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.authors);
    }

    public void addAuthor(String name) {
        if (this.authors == null) {
            this.authors = new HashSet<String>();
        }
        this.authors.add(name);
    }

    public void setSeed(long seed) {
        if (this.visited) {
            return;
        }
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public BlockPos getSpawn() {
        return this.spawn;
    }

    public void setSpawn(BlockPos spawn) {
        this.spawn = spawn;
    }

    public boolean isInstabilityEnabled() {
        return this.instabilityEnabled;
    }

    public void setInstabilityEnabled(boolean instabilityEnabled) {
        this.instabilityEnabled = instabilityEnabled;
        this.func_76185_a();
    }

    public int getBaseInstability() {
        return this.instability;
    }

    public void setPages(List<ItemStack> pages) {
        this.pages.clear();
        this.pages.addAll(pages);
        this.func_76185_a();
    }

    public List<ItemStack> getPages() {
        return Collections.unmodifiableList(this.pages);
    }

    public void addSymbol(ResourceLocation symbol2, int instability) {
        this.symbols.add(symbol2);
        this.instability = (short)(this.instability + instability);
        this.func_76185_a();
    }

    public List<ResourceLocation> getSymbols(boolean isRemote) {
        if (!this.visited && !isRemote) {
            this.symbols.clear();
            for (ItemStack page : this.pages) {
                ResourceLocation symbol2 = Page.getSymbol(page);
                if (symbol2 == null) continue;
                this.symbols.add(symbol2);
            }
            GrammarTree tree = new GrammarTree(GrammarRules.ROOT);
            List<ResourceLocation> collapsedNames = new LinkedList<ResourceLocation>();
            collapsedNames.addAll(this.symbols);
            tree.parseTerminals(collapsedNames, new Random(this.seed));
            if (DebugFlags.grammar) {
                System.out.println(" == Parsed Tree ==");
                tree.print();
            }
            collapsedNames = tree.getExpanded(new Random(this.seed));
            this.symbols = new LinkedList<ResourceLocation>();
            this.symbols.addAll(collapsedNames);
            if (DebugFlags.grammar) {
                System.out.println(" == Produced Tree ==");
                tree.print();
            }
        }
        return Collections.unmodifiableList(this.symbols);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        AgeDataData loadeddata = AgeDataLoaderManager.load(nbttagcompound);
        this.agename = loadeddata.agename;
        this.authors = loadeddata.authors;
        this.seed = loadeddata.seed;
        this.uuid = loadeddata.uuid;
        this.visited = loadeddata.visited;
        this.dead = loadeddata.dead;
        this.worldtime = loadeddata.worldtime;
        this.instability = loadeddata.instability;
        this.instabilityEnabled = loadeddata.instabilityEnabled;
        this.setSpawn(loadeddata.spawn);
        this.pages = loadeddata.pages;
        this.symbols = loadeddata.symbols;
        this.datacompound = loadeddata.datacompound;
        this.cruft = loadeddata.cruft;
        if (this.datacompound == null) {
            this.datacompound = new NBTTagCompound();
        }
        SymbolRemappings.remap(this.pages);
        SymbolRemappings.remap(this.symbols);
        this.updated = true;
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("Version", "4.3");
        nbttagcompound.func_74778_a("AgeName", this.agename);
        nbttagcompound.func_74772_a("Seed", this.seed);
        nbttagcompound.func_74778_a("UUID", this.uuid.toString());
        nbttagcompound.func_74777_a("BaseIns", this.instability);
        nbttagcompound.func_74757_a("InstabilityEnabled", this.instabilityEnabled);
        nbttagcompound.func_74757_a("Visited", this.visited);
        nbttagcompound.func_74757_a("Dead", this.dead);
        nbttagcompound.func_74782_a("DataCompound", (NBTBase)this.datacompound);
        nbttagcompound.func_74772_a("WorldTime", this.worldtime);
        if (this.spawn != null) {
            nbttagcompound.func_74768_a("SpawnX", this.spawn.func_177958_n());
            nbttagcompound.func_74768_a("SpawnY", this.spawn.func_177956_o());
            nbttagcompound.func_74768_a("SpawnZ", this.spawn.func_177952_p());
        }
        NBTTagList list = new NBTTagList();
        for (ItemStack itemStack : this.pages) {
            list.func_74742_a((NBTBase)itemStack.func_77978_p());
        }
        nbttagcompound.func_74782_a("Pages", (NBTBase)list);
        LinkedList<String> collapsedName = new LinkedList<String>();
        for (ResourceLocation rl : this.symbols) {
            collapsedName.add(rl.toString());
        }
        nbttagcompound.func_74782_a("Symbols", (NBTBase)NBTUtils.writeStringCollection(new NBTTagList(), collapsedName));
        if (this.authors != null) {
            nbttagcompound.func_74782_a("Authors", (NBTBase)NBTUtils.writeStringCollection(new NBTTagList(), this.authors));
        }
        if (this.cruft != null && this.cruft.size() > 0) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            for (Map.Entry<String, NBTBase> elem : this.cruft.entrySet()) {
                nBTTagCompound.func_74782_a(elem.getKey(), elem.getValue());
            }
            nbttagcompound.func_74782_a("Cruft", (NBTBase)nBTTagCompound);
        }
        return nbttagcompound;
    }

    public static AgeData getMPAgeData(int uid) {
        MapStorage storage = Mystcraft.getStorage(false);
        String s = AgeData.getStringID(uid);
        if (storage == null) {
            throw new RuntimeException("Mystcraft could not retrieve the agedata file.  The storage object is null.");
        }
        AgeData age = (AgeData)storage.func_75742_a(AgeData.class, s);
        if (age == null) {
            age = new AgeData(s);
            storage.func_75745_a(s, (WorldSavedData)age);
            age.func_76185_a();
        }
        return age;
    }

    public static AgeData getAge(int uid, boolean isRemote) {
        MapStorage storage = Mystcraft.getStorage(!isRemote);
        if (storage == null) {
            throw new RuntimeException("Mystcraft could not load the agedata file.  The storage object is null. (Attempted as " + (isRemote ? "remote" : "server") + ")");
        }
        return AgeData.getAge(uid, storage);
    }

    public static AgeData getAge(int uid, MapStorage storage) {
        if (!DimensionManager.isDimensionRegistered((int)uid)) {
            return null;
        }
        if (DimensionManager.getProviderType((int)uid) != Mystcraft.dimensionType) {
            return null;
        }
        if (storage == null) {
            throw new RuntimeException("Mystcraft could not load the agedata file.  The storage object is null.)");
        }
        String s = AgeData.getStringID(uid);
        AgeData age = (AgeData)storage.func_75742_a(AgeData.class, s);
        if (age == null) {
            age = new AgeData(s);
            storage.func_75745_a(s, (WorldSavedData)age);
            age.agename = "Age " + uid;
            age.seed = Mystcraft.getLevelSeed(storage) + new Random(uid).nextLong();
            age.uuid = UUID.randomUUID();
            age.worldtime = 0L;
            age.setSpawn(null);
            age.instability = 0;
            age.instabilityEnabled = true;
            age.visited = false;
            age.dead = false;
            age.updated = false;
            age.func_76185_a();
        }
        return age;
    }

    public void recreate(int uid) {
        this.agename = "Age " + uid;
        this.seed += new Random(uid).nextLong();
        this.uuid = UUID.randomUUID();
        this.worldtime = 0L;
        this.setSpawn(null);
        this.instability = 0;
        this.instabilityEnabled = true;
        this.visited = false;
        this.dead = false;
        this.updated = false;
        this.pages.clear();
        this.symbols.clear();
        if (this.authors != null) {
            this.authors.clear();
        }
        this.datacompound = new NBTTagCompound();
        this.func_76185_a();
    }

    public static String getStringID(int uid) {
        return "agedata_" + uid;
    }

    public StorageObject getStorageObject(String string) {
        if (!this.datacompound.func_74764_b(string)) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            this.datacompound.func_74782_a(string, (NBTBase)nbttagcompound);
        }
        return new NBTTagCompoundWrapper(this.datacompound.func_74775_l(string), this.sharedDirty, this.sharedResend);
    }

    public void setWorldTime(long time) {
        this.worldtime = time;
        this.func_76185_a();
    }

    public long getWorldTime() {
        return this.worldtime;
    }

    public NBTBase popCruft(String string) {
        if (this.cruft == null) {
            return null;
        }
        return this.cruft.remove(string);
    }

    public static class AgeDataData {
        public String agename;
        public Set<String> authors = new HashSet<String>();
        public long seed;
        public UUID uuid;
        public short instability;
        public boolean instabilityEnabled;
        public BlockPos spawn;
        public List<ItemStack> pages = new ArrayList<ItemStack>();
        public List<ResourceLocation> symbols = new ArrayList<ResourceLocation>();
        public boolean visited;
        public boolean dead;
        public NBTTagCompound datacompound;
        public long worldtime;
        public String version;
        public Map<String, NBTBase> cruft = new HashMap<String, NBTBase>();
    }
}

