/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.gen;

import com.xcompwiz.mystcraft.world.gen.MapGenAdvanced;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class MapGenSpheresMyst
extends MapGenAdvanced {
    public MapGenSpheresMyst(long seed, Block block) {
        this(seed, block.func_176223_P());
    }

    public MapGenSpheresMyst(long seed, IBlockState state) {
        super(seed, state);
    }

    protected void generateLargeCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double baseX, double baseY, double baseZ) {
        this.generateCaveNode(seed, chunkX, chunkZ, primer, baseX, baseY, baseZ, 1.0f + this.rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 1.0);
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double baseX, double baseY, double baseZ, float angleA, float angleB, float angleC, int loopc, int maxLoops, double squash) {
        boolean flag1;
        double chunkXmid = chunkX * 16 + 8;
        double chunkZmid = chunkZ * 16 + 8;
        int layers = 256;
        float f = 0.0f;
        float f1 = 0.0f;
        Random random = new Random(seed);
        if (maxLoops <= 0) {
            int i = this.range * 16 - 16;
            maxLoops = i - random.nextInt(i / 4);
        }
        boolean flag = false;
        if (loopc == -1) {
            loopc = maxLoops / 2;
            flag = true;
        }
        int j = random.nextInt(maxLoops / 2) + maxLoops / 4;
        boolean bl = flag1 = random.nextInt(6) == 0;
        while (loopc < maxLoops) {
            double d2 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)loopc * (float)Math.PI / (float)maxLoops)) * angleA * 1.0f);
            double d3 = d2 * squash;
            float f2 = MathHelper.func_76134_b((float)angleC);
            float f3 = MathHelper.func_76126_a((float)angleC);
            baseX += (double)(MathHelper.func_76134_b((float)angleB) * f2);
            baseY += (double)f3;
            baseZ += (double)(MathHelper.func_76126_a((float)angleB) * f2);
            angleC = flag1 ? (angleC *= 0.92f) : (angleC *= 0.7f);
            angleC += f1 * 0.1f;
            angleB += f * 0.1f;
            f1 *= 0.9f;
            f *= 0.75f;
            f1 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag && loopc == j && angleA > 1.0f && maxLoops > 0) {
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, primer, baseX, baseY, baseZ, random.nextFloat() * 0.5f + 0.5f, angleB - 1.5707964f, angleC / 3.0f, loopc, maxLoops, 1.0);
                this.generateCaveNode(random.nextLong(), chunkX, chunkZ, primer, baseX, baseY, baseZ, random.nextFloat() * 0.5f + 0.5f, angleB + 1.5707964f, angleC / 3.0f, loopc, maxLoops, 1.0);
                return;
            }
            if (flag || random.nextInt(4) != 0) {
                double xoffset = baseX - chunkXmid;
                double yoffset = baseZ - chunkZmid;
                double zoffset = maxLoops - loopc;
                double d7 = angleA + 2.0f + 16.0f;
                if (xoffset * xoffset + yoffset * yoffset - zoffset * zoffset > d7 * d7) {
                    return;
                }
                if (!(baseX < chunkXmid - 16.0 - d2 * 2.0 || baseZ < chunkZmid - 16.0 - d2 * 2.0 || baseX > chunkXmid + 16.0 + d2 * 2.0 || baseZ > chunkZmid + 16.0 + d2 * 2.0)) {
                    int minX = MathHelper.func_76128_c((double)(baseX - d2)) - chunkX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(baseX + d2)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(baseY - d3)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(baseY + d3)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(baseZ - d2)) - chunkZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(baseZ + d2)) - chunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 1) {
                        minY = 1;
                    }
                    if (maxY > layers) {
                        maxY = layers;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    for (int localY = minY; localY < maxY; ++localY) {
                        double yfactor = ((double)localY + 0.5 - baseY) / d3;
                        double yfactorSq = yfactor * yfactor;
                        for (int localZ = minZ; localZ < maxZ; ++localZ) {
                            double zfactor = ((double)(localZ + chunkZ * 16) + 0.5 - baseZ) / d2;
                            double zfactorSq = zfactor * zfactor;
                            for (int localX = minX; localX < maxX; ++localX) {
                                double total;
                                double xfactor = ((double)(localX + chunkX * 16) + 0.5 - baseX) / d2;
                                double xfactorSq = xfactor * xfactor;
                                if (!(xfactorSq + zfactorSq < 1.0) || !((total = xfactorSq + yfactorSq + zfactorSq) < 1.0)) continue;
                                this.placeBlock(primer, localX, localY, localZ);
                            }
                        }
                    }
                    if (flag) break;
                }
            }
            ++loopc;
        }
    }

    @Override
    protected void recursiveGenerate(World par1World, int x, int z, int chunkX, int chunkZ, ChunkPrimer primer) {
        float roll = this.rand.nextFloat();
        if (roll > 0.05f) {
            return;
        }
        double dx = x * 16 + this.rand.nextInt(16);
        double dy = this.rand.nextInt(this.rand.nextInt(192) + 1) + 32;
        double dz = z * 16 + this.rand.nextInt(16);
        this.generateCaveNode(this.rand.nextLong(), chunkX, chunkZ, primer, dx, dy, dz, 1.0f + this.rand.nextFloat() * 4.0f, 0.0f, 0.0f, -1, -1, 1.0);
    }
}

