/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.handlers;

import funwayguy.skygrid.core.SG_Settings;
import funwayguy.skygrid.core.SkyGrid;
import funwayguy.skygrid.handlers.ConfigHandler;
import funwayguy.skygrid.handlers.OldFoodStats;
import funwayguy.skygrid.util.CustomLootTableManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FoodStats;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandler {
    public static Map<String, boolean[]> spawnCache = new HashMap<String, boolean[]>();
    private static boolean lootLoaded = false;

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && SG_Settings.oldRegen) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            FoodStats old = player.func_71024_bL();
            if (old instanceof OldFoodStats) {
                return;
            }
            NBTTagCompound tags = new NBTTagCompound();
            OldFoodStats nStats = new OldFoodStats();
            old.func_75117_b(tags);
            nStats.func_75112_a(tags);
            ObfuscationReflectionHelper.setPrivateValue(EntityPlayer.class, (Object)player, (Object)((Object)nStats), (String[])new String[]{"field_71100_bB", "foodStats"});
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || !(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        Random rand = player.field_70170_p.field_73012_v;
        if (player.func_70005_c_().equalsIgnoreCase("darkosto") && !CustomLootTableManager.dad && rand.nextInt(10) == 0 && player.field_70173_aa == 2400) {
            CustomLootTableManager.dad = true;
            String s = String.format(CustomLootTableManager.dadPre[rand.nextInt(CustomLootTableManager.dadPre.length)], CustomLootTableManager.dadName[rand.nextInt(CustomLootTableManager.dadName.length)], CustomLootTableManager.dadPost[rand.nextInt(CustomLootTableManager.dadPost.length)]);
            player.func_145747_a((ITextComponent)new TextComponentString("" + TextFormatting.GREEN + TextFormatting.BOLD + TextFormatting.UNDERLINE + TextFormatting.ITALIC + s));
            EntityFireworkRocket firework = new EntityFireworkRocket(player.field_70170_p);
            firework.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            player.field_70170_p.func_72838_d((Entity)firework);
        }
    }

    @SubscribeEvent
    public void getPotentialSpawn(WorldEvent.PotentialSpawns event) {
        if (SG_Settings.spawnFix && !event.getWorld().field_72995_K && event.getWorld().func_175624_G() == SkyGrid.gridWorld) {
            boolean b;
            int bx = event.getPos().func_177958_n();
            int by = event.getPos().func_177956_o();
            bx = (bx % 16 + 16) % 16;
            by = (by % 16 + 16) % 16;
            int cx = (event.getPos().func_177958_n() - bx) / 16;
            int cy = (event.getPos().func_177956_o() - by) / 16;
            String key = cx + "," + cy + "," + event.getWorld().field_73011_w.getDimension();
            boolean[] ba = spawnCache.get(key);
            boolean bl = b = ba != null && ba[by * 16 + bx];
            if (b) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (SG_Settings.spawnFix && !event.getWorld().field_72995_K && event.getWorld().func_175624_G() == SkyGrid.gridWorld) {
            int bx = event.getPos().func_177958_n();
            int by = event.getPos().func_177956_o();
            bx = (bx % 16 + 16) % 16;
            by = (by % 16 + 16) % 16;
            int cx = (event.getPos().func_177958_n() - bx) / 16;
            int cy = (event.getPos().func_177956_o() - by) / 16;
            String key = cx + "," + cy + "," + event.getWorld().field_73011_w.getDimension();
            boolean[] ba = spawnCache.get(key);
            if (ba != null) {
                ba[by * 16 + bx] = true;
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.PlaceEvent event) {
        if (SG_Settings.spawnFix && !event.getWorld().field_72995_K && event.getWorld().func_175624_G() == SkyGrid.gridWorld) {
            int bx = event.getPos().func_177958_n();
            int by = event.getPos().func_177956_o();
            bx = (bx % 16 + 16) % 16;
            by = (by % 16 + 16) % 16;
            int cx = (event.getPos().func_177958_n() - bx) / 16;
            int cy = (event.getPos().func_177956_o() - by) / 16;
            String key = cx + "," + cy + "," + event.getWorld().field_73011_w.getDimension();
            boolean[] ba = spawnCache.get(key);
            if (ba != null) {
                ba[by * 16 + bx] = false;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource() != null && event.getEntityLiving() instanceof EntityPlayer) {
            CustomLootTableManager.dad = false;
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("skygrid")) {
            ConfigHandler.config.save();
            ConfigHandler.initConfigs();
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K && !lootLoaded) {
            CustomLootTableManager.LoadLoot(new File("config/skygrid/loot.json"), event.getWorld().func_184146_ak());
            lootLoaded = true;
            spawnCache.clear();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && !event.getWorld().func_73046_m().func_71278_l()) {
            lootLoaded = false;
            CustomLootTableManager.dad = false;
        }
    }
}

