/*
 * Decompiled with CFR 0.152.
 */
package funwayguy.skygrid.world;

import funwayguy.skygrid.config.GridBlock;
import funwayguy.skygrid.config.GridRegistry;
import funwayguy.skygrid.core.SG_Settings;
import funwayguy.skygrid.handlers.EventHandler;
import funwayguy.skygrid.world.PostGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;

public class ChunkProviderGrid
implements IChunkGenerator {
    private World worldObj;
    private Random random;
    private final List<GridBlock> gridBlocks;
    private Map<String, List<Biome.SpawnListEntry>> cachedSpawns = new HashMap<String, List<Biome.SpawnListEntry>>();

    public ChunkProviderGrid(World world, long seed, List<GridBlock> blocks) {
        this.worldObj = world;
        this.random = new Random(seed);
        this.gridBlocks = blocks;
    }

    public Chunk func_185932_a(int x, int z) {
        Biome[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        int spaceX = this.random.nextInt(Math.max(1, SG_Settings.dist + 1));
        int spaceY = this.random.nextInt(Math.max(1, SG_Settings.dist + 1));
        int spaceZ = this.random.nextInt(Math.max(1, SG_Settings.dist + 1));
        if (!SG_Settings.rngSpacing) {
            spaceY = spaceZ = SG_Settings.dist;
            spaceX = spaceZ;
        }
        boolean[] validSpawns = new boolean[256];
        int amount = 256 / spaceY * (16 / spaceX) * (16 / spaceZ);
        List<GridBlock> randomBlocks = GridRegistry.getRandom(this.random, this.gridBlocks, abiomegenbase[0], this.worldObj.field_73011_w.getDimension(), amount);
        int n = 0;
        for (int i = 0; i < 256 && i < SG_Settings.height; i += spaceY) {
            for (int j = x * 16 % spaceX; j < 16; j += spaceX) {
                for (int k = z * 16 % spaceZ; k < 16; k += spaceZ) {
                    IBlockState plant;
                    validSpawns[k * 16 + j] = true;
                    GridBlock gb = randomBlocks.get(n);
                    ++n;
                    chunkprimer.func_177855_a(j, i, k, gb.getState());
                    IBlockState iBlockState = plant = gb.plants.size() <= 0 ? null : gb.plants.get(this.random.nextInt(gb.plants.size())).getState();
                    if (i < 255 && plant != null) {
                        chunkprimer.func_177855_a(j, i + 1, k, plant);
                    }
                    if (!(gb.getState().func_177230_c() instanceof ITileEntityProvider)) continue;
                    PostGenerator.addLocation(this.worldObj.field_73011_w.getDimension(), x, z, new BlockPos(x * 16 + j, i, z * 16 + k));
                }
            }
        }
        EventHandler.spawnCache.put(x + "," + z + "," + this.worldObj.field_73011_w.getDimension(), validSpawns);
        if (x == 0 && z == 0) {
            chunkprimer.func_177855_a(0, SG_Settings.height, 0, Blocks.field_150357_h.func_176223_P());
        }
        Chunk chunk = new Chunk(this.worldObj, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)Biome.func_185362_a((Biome)abiomegenbase[l]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int p_73153_2_, int p_73153_3_) {
        if (!SG_Settings.populate) {
            return;
        }
        int i = p_73153_2_ * 16;
        int j = p_73153_3_ * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biomegenbase = this.worldObj.func_180494_b(new BlockPos(i + 16, 0, j + 16));
        biomegenbase.func_180624_a(this.worldObj, this.random, blockpos);
    }

    public boolean func_185933_a(Chunk p_177460_2_, int p_177460_3_, int p_177460_4_) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biomegenbase = this.worldObj.func_180494_b(pos);
        String key = biomegenbase.getRegistryName().toString() + ":" + creatureType.toString();
        List list = this.cachedSpawns.get(key);
        if (list == null) {
            list = biomegenbase.func_76747_a(creatureType);
            this.cachedSpawns.put(key, list);
        }
        return list;
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk p_180514_1_, int p_180514_2_, int p_180514_3_) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

