/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.event;

import cityofskytcd.chineseworkshop.library.ItemDefinition;
import cityofskytcd.chineseworkshop.library.Selections;
import cityofskytcd.chineseworkshop.network.CWNetworkChannel;
import cityofskytcd.chineseworkshop.network.WheelMovePacket;
import cityofskytcd.chineseworkshop.proxy.ClientProxy;
import com.google.common.collect.ImmutableList;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class HudHandler {
    private static boolean showGui = false;
    private static boolean animating = false;
    private static float animationTick = 0.0f;
    private static float[] badgeProcess = new float[0];

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!showGui && mc.field_71415_G) {
            if (ClientProxy.kbSelect.func_151470_d() && Selections.findSelection(mc.field_71439_g.func_184614_ca()) != null) {
                showGui = true;
                animating = true;
            }
        } else if (showGui && !ClientProxy.kbSelect.func_151470_d()) {
            showGui = false;
            animating = true;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onMouseInput(MouseEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (showGui && event.getDwheel() != 0) {
            if (!Minecraft.func_71410_x().field_71415_G) {
                showGui = false;
                animating = false;
                animationTick = 0.0f;
                return;
            }
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack held = player.func_184614_ca();
            if (held.func_190926_b()) {
                showGui = false;
                animating = false;
                animationTick = 0.0f;
                return;
            }
            ImmutableList<ItemDefinition> selection = Selections.findSelection(held);
            if (selection != null) {
                ItemDefinition definition = ItemDefinition.of(held);
                for (int i = 0; i < selection.size(); ++i) {
                    if (!definition.equals(selection.get(i))) continue;
                    i = (i + selection.size() + (event.getDwheel() < 0 ? 1 : -1)) % selection.size();
                    CWNetworkChannel.INSTANCE.sendToServer(new WheelMovePacket(i));
                    ItemStack stack = ((ItemDefinition)selection.get(i)).getItemStack();
                    stack.func_190920_e(held.func_190916_E());
                    stack.func_77982_d(held.func_77978_p());
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
                    break;
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void drawHudPost(RenderGameOverlayEvent.Post event) {
        if ((showGui || animating) && event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Minecraft mc = Minecraft.func_71410_x();
            ItemStack held = mc.field_71439_g.func_184614_ca();
            if (held.func_190926_b()) {
                return;
            }
            ImmutableList<ItemDefinition> selection = Selections.findSelection(held);
            if (selection == null) {
                return;
            }
            ScaledResolution res = event.getResolution();
            float xStart = res.func_78326_a() / 2;
            float yStart = res.func_78328_b() / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)xStart, (float)yStart, (float)0.0f);
            if (animating) {
                animationTick += mc.func_184121_ak() * (float)(showGui ? 1 : -1);
                if ((animationTick = MathHelper.func_76131_a((float)animationTick, (float)0.0f, (float)9.0f)) == 9.0f) {
                    animating = false;
                } else {
                    if (!showGui && (double)animationTick < 0.01) {
                        animating = false;
                        GlStateManager.func_179121_F();
                        return;
                    }
                    double scale = Math.sqrt(animationTick) / 3.0;
                    GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
                }
            }
            HudHandler.drawBadge(mc, held, 0.0f, true);
            if (selection.size() < 2) {
                CrashReport crash = CrashReport.func_85055_a((Throwable)new Exception(), (String)"Number of options smaller than 2");
                mc.func_71404_a(crash);
            }
            float degPer = 360.0f / (float)selection.size();
            boolean matched = false;
            if (selection.size() != badgeProcess.length) {
                badgeProcess = new float[selection.size()];
            }
            for (int i = 0; i < selection.size(); ++i) {
                ItemDefinition definition = (ItemDefinition)selection.get(i);
                GlStateManager.func_179094_E();
                float rad = (float)((double)((((float)i + (selection.size() % 2 == 0 ? 0.5f : 0.0f)) * degPer + 180.0f) / 180.0f) * Math.PI);
                GlStateManager.func_179137_b((double)(Math.sin(rad) * 60.0), (double)(Math.cos(rad) * 60.0), (double)0.0);
                GlStateManager.func_179139_a((double)0.618, (double)0.618, (double)0.618);
                boolean match = !matched && definition.equals(ItemDefinition.of(held));
                matched = matched || match;
                int n = i;
                badgeProcess[n] = badgeProcess[n] + (match ? mc.func_184121_ak() : -mc.func_184121_ak());
                HudHandler.badgeProcess[i] = MathHelper.func_76131_a((float)badgeProcess[i], (float)0.0f, (float)10.0f);
                HudHandler.drawBadge(mc, definition.getItemStack(), badgeProcess[i], false);
                GlStateManager.func_179121_F();
            }
            if (!matched) {
                CrashReport crash = CrashReport.func_85055_a((Throwable)new Exception(), (String)"Options do not contain item itself");
                mc.func_71404_a(crash);
            }
            GlStateManager.func_179121_F();
        }
    }

    private static void drawCenteredString(FontRenderer fontRendererIn, String text, float x, float y) {
        fontRendererIn.func_175063_a(text, x - (float)(fontRendererIn.func_78256_a(text) / 2), y, 0xFFFFFF);
    }

    private static void drawBadge(Minecraft mc, ItemStack stack, float color, boolean rotation) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179090_x();
        color = (float)(Math.sin((color - 5.0f) / 5.0f) + 0.5);
        GlStateManager.func_179131_c((float)(color * 0.1f), (float)(color * 0.5f), (float)(color * 0.9f), (float)0.3f);
        GL11.glBegin((int)6);
        GL11.glVertex2f((float)0.0f, (float)-30.0f);
        GL11.glVertex2f((float)-26.0f, (float)-15.0f);
        GL11.glVertex2f((float)-26.0f, (float)15.0f);
        GL11.glVertex2f((float)0.0f, (float)30.0f);
        GL11.glVertex2f((float)26.0f, (float)15.0f);
        GL11.glVertex2f((float)26.0f, (float)-15.0f);
        GL11.glEnd();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        HudHandler.drawCenteredString(mc.field_71466_p, stack.func_82833_r(), 0.0f, 8.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
        IBakedModel bakedModel = mc.func_175599_af().func_184393_a(stack, (World)null, (EntityLivingBase)null);
        if (rotation && bakedModel.func_177556_c()) {
            RenderHelper.func_74520_c();
            GlStateManager.func_179109_b((float)0.0f, (float)-5.0f, (float)150.0f);
            GlStateManager.func_179152_a((float)10.0f, (float)-10.0f, (float)10.0f);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            GlStateManager.func_179141_d();
            GlStateManager.func_179114_b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(Minecraft.func_71386_F() % 3600L / 10L), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74519_b();
            mc.func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
            GlStateManager.func_179118_c();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
        } else {
            RenderHelper.func_74520_c();
            mc.func_175599_af().func_180450_b(stack, -8, -12);
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void drawHudPre(RenderGameOverlayEvent.Pre event) {
        if ((showGui || animating) && event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTooltip(ItemTooltipEvent event) {
        if (Selections.findSelection(ItemDefinition.of(event.getItemStack())) != null) {
            String os;
            String key = ClientProxy.kbSelect.func_151463_i() == 56 ? ((os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH)).startsWith("win") ? "LAlt" : (os.startsWith("mac") ? "Option" : ClientProxy.kbSelect.getDisplayName())) : ClientProxy.kbSelect.getDisplayName();
            event.getToolTip().add(I18n.func_135052_a((String)"chineseworkshop.tip.selectable", (Object[])new Object[]{key}));
        }
    }
}

