/*
 * Decompiled with CFR 0.152.
 */
package cityofskytcd.chineseworkshop.library;

import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class ItemDefinition
implements Comparable<ItemDefinition> {
    private final Item item;
    private final int metadata;

    public static ItemDefinition of(Item item) {
        return ItemDefinition.of(item, 0);
    }

    public static ItemDefinition of(ItemStack stack) {
        return ItemDefinition.of(stack.func_77973_b(), stack.func_77981_g() ? stack.func_77960_j() : 0);
    }

    public static ItemDefinition of(Block block) {
        return ItemDefinition.of(Item.func_150898_a((Block)block));
    }

    public static ItemDefinition of(Item item, int metadata) {
        return new ItemDefinition(item, metadata);
    }

    public ItemDefinition(Item item, int metadata) {
        this.item = item;
        this.metadata = metadata;
    }

    public ItemStack withSize(int size) {
        return new ItemStack(this.item, size, this.metadata);
    }

    public Item getItem() {
        return this.item;
    }

    public int getMetadata() {
        return this.metadata;
    }

    public ItemStack getItemStack() {
        return new ItemStack(this.item, 1, this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDefinition that = (ItemDefinition)o;
        return this.metadata == that.metadata && Objects.equals(this.item, that.item);
    }

    public int hashCode() {
        return this.item.hashCode() * 31 + this.metadata;
    }

    @Override
    public int compareTo(ItemDefinition o) {
        int result = this.item.getRegistryName().compareTo(o.item.getRegistryName());
        return result == 0 ? this.metadata - o.metadata : result;
    }

    public String toString() {
        return this.item.getRegistryName() + ":" + this.metadata;
    }
}

