/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.limitlessstructureblocks.gui;

import com.bloodnbonesgaming.limitlessstructureblocks.LimitlessStructureBlocks;
import com.bloodnbonesgaming.limitlessstructureblocks.network.PacketSyncStructureBlock;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.tileentity.TileEntityStructure;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiEditStructureOverride
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int[] LEGAL_KEY_CODES = new int[]{203, 205, 14, 211, 199, 207};
    private final TileEntityStructure tileStructure;
    private Mirror mirror = Mirror.NONE;
    private Rotation rotation = Rotation.NONE;
    private TileEntityStructure.Mode mode = TileEntityStructure.Mode.DATA;
    private boolean ignoreEntities;
    private boolean showAir;
    private boolean showBoundingBox;
    private GuiTextField nameEdit;
    private GuiTextField posXEdit;
    private GuiTextField posYEdit;
    private GuiTextField posZEdit;
    private GuiTextField sizeXEdit;
    private GuiTextField sizeYEdit;
    private GuiTextField sizeZEdit;
    private GuiTextField integrityEdit;
    private GuiTextField seedEdit;
    private GuiTextField dataEdit;
    private GuiButton doneButton;
    private GuiButton cancelButton;
    private GuiButton saveButton;
    private GuiButton loadButton;
    private GuiButton rotateZeroDegreesButton;
    private GuiButton rotateNinetyDegreesButton;
    private GuiButton rotate180DegreesButton;
    private GuiButton rotate270DegressButton;
    private GuiButton modeButton;
    private GuiButton detectSizeButton;
    private GuiButton showEntitiesButton;
    private GuiButton mirrorButton;
    private GuiButton showAirButton;
    private GuiButton showBoundingBoxButton;
    private final List<GuiTextField> tabOrder = Lists.newArrayList();
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0###");

    public GuiEditStructureOverride(TileEntityStructure p_i47142_1_) {
        this.tileStructure = p_i47142_1_;
        this.decimalFormat.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.US));
    }

    public void func_73876_c() {
        this.nameEdit.func_146178_a();
        this.posXEdit.func_146178_a();
        this.posYEdit.func_146178_a();
        this.posZEdit.func_146178_a();
        this.sizeXEdit.func_146178_a();
        this.sizeYEdit.func_146178_a();
        this.sizeZEdit.func_146178_a();
        this.integrityEdit.func_146178_a();
        this.seedEdit.func_146178_a();
        this.dataEdit.func_146178_a();
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.clear();
        this.doneButton = this.func_189646_b(new GuiButton(0, this.field_146294_l / 2 - 4 - 150, 210, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
        this.cancelButton = this.func_189646_b(new GuiButton(1, this.field_146294_l / 2 + 4, 210, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0])));
        this.saveButton = this.func_189646_b(new GuiButton(9, this.field_146294_l / 2 + 4 + 100, 185, 50, 20, I18n.func_135052_a((String)"structure_block.button.save", (Object[])new Object[0])));
        this.loadButton = this.func_189646_b(new GuiButton(10, this.field_146294_l / 2 + 4 + 100, 185, 50, 20, I18n.func_135052_a((String)"structure_block.button.load", (Object[])new Object[0])));
        this.modeButton = this.func_189646_b(new GuiButton(18, this.field_146294_l / 2 - 4 - 150, 185, 50, 20, "MODE"));
        this.detectSizeButton = this.func_189646_b(new GuiButton(19, this.field_146294_l / 2 + 4 + 100, 120, 50, 20, I18n.func_135052_a((String)"structure_block.button.detect_size", (Object[])new Object[0])));
        this.showEntitiesButton = this.func_189646_b(new GuiButton(20, this.field_146294_l / 2 + 4 + 100, 160, 50, 20, "ENTITIES"));
        this.mirrorButton = this.func_189646_b(new GuiButton(21, this.field_146294_l / 2 - 20, 185, 40, 20, "MIRROR"));
        this.showAirButton = this.func_189646_b(new GuiButton(22, this.field_146294_l / 2 + 4 + 100, 80, 50, 20, "SHOWAIR"));
        this.showBoundingBoxButton = this.func_189646_b(new GuiButton(23, this.field_146294_l / 2 + 4 + 100, 80, 50, 20, "SHOWBB"));
        this.rotateZeroDegreesButton = this.func_189646_b(new GuiButton(11, this.field_146294_l / 2 - 1 - 40 - 1 - 40 - 20, 185, 40, 20, "0"));
        this.rotateNinetyDegreesButton = this.func_189646_b(new GuiButton(12, this.field_146294_l / 2 - 1 - 40 - 20, 185, 40, 20, "90"));
        this.rotate180DegreesButton = this.func_189646_b(new GuiButton(13, this.field_146294_l / 2 + 1 + 20, 185, 40, 20, "180"));
        this.rotate270DegressButton = this.func_189646_b(new GuiButton(14, this.field_146294_l / 2 + 1 + 40 + 1 + 20, 185, 40, 20, "270"));
        this.nameEdit = new GuiTextField(2, this.field_146289_q, this.field_146294_l / 2 - 152, 40, 300, 20);
        this.nameEdit.func_146203_f(64);
        this.nameEdit.func_146180_a(this.tileStructure.func_189715_d());
        this.tabOrder.add(this.nameEdit);
        BlockPos blockpos = this.tileStructure.func_189711_e();
        this.posXEdit = new GuiTextField(3, this.field_146289_q, this.field_146294_l / 2 - 152, 80, 80, 20);
        this.posXEdit.func_146203_f(15);
        this.posXEdit.func_146180_a(Integer.toString(blockpos.func_177958_n()));
        this.tabOrder.add(this.posXEdit);
        this.posYEdit = new GuiTextField(4, this.field_146289_q, this.field_146294_l / 2 - 72, 80, 80, 20);
        this.posYEdit.func_146203_f(15);
        this.posYEdit.func_146180_a(Integer.toString(blockpos.func_177956_o()));
        this.tabOrder.add(this.posYEdit);
        this.posZEdit = new GuiTextField(5, this.field_146289_q, this.field_146294_l / 2 + 8, 80, 80, 20);
        this.posZEdit.func_146203_f(15);
        this.posZEdit.func_146180_a(Integer.toString(blockpos.func_177952_p()));
        this.tabOrder.add(this.posZEdit);
        BlockPos blockpos1 = this.tileStructure.func_189717_g();
        this.sizeXEdit = new GuiTextField(6, this.field_146289_q, this.field_146294_l / 2 - 152, 120, 80, 20);
        this.sizeXEdit.func_146203_f(15);
        this.sizeXEdit.func_146180_a(Integer.toString(blockpos1.func_177958_n()));
        this.tabOrder.add(this.sizeXEdit);
        this.sizeYEdit = new GuiTextField(7, this.field_146289_q, this.field_146294_l / 2 - 72, 120, 80, 20);
        this.sizeYEdit.func_146203_f(15);
        this.sizeYEdit.func_146180_a(Integer.toString(blockpos1.func_177956_o()));
        this.tabOrder.add(this.sizeYEdit);
        this.sizeZEdit = new GuiTextField(8, this.field_146289_q, this.field_146294_l / 2 + 8, 120, 80, 20);
        this.sizeZEdit.func_146203_f(15);
        this.sizeZEdit.func_146180_a(Integer.toString(blockpos1.func_177952_p()));
        this.tabOrder.add(this.sizeZEdit);
        this.integrityEdit = new GuiTextField(15, this.field_146289_q, this.field_146294_l / 2 - 152, 120, 80, 20);
        this.integrityEdit.func_146203_f(15);
        this.integrityEdit.func_146180_a(this.decimalFormat.format(this.tileStructure.func_189702_n()));
        this.tabOrder.add(this.integrityEdit);
        this.seedEdit = new GuiTextField(16, this.field_146289_q, this.field_146294_l / 2 - 72, 120, 80, 20);
        this.seedEdit.func_146203_f(31);
        this.seedEdit.func_146180_a(Long.toString(this.tileStructure.func_189719_o()));
        this.tabOrder.add(this.seedEdit);
        this.dataEdit = new GuiTextField(17, this.field_146289_q, this.field_146294_l / 2 - 152, 120, 240, 20);
        this.dataEdit.func_146203_f(128);
        this.dataEdit.func_146180_a(this.tileStructure.func_189708_j());
        this.tabOrder.add(this.dataEdit);
        this.mirror = this.tileStructure.func_189716_h();
        this.updateMirrorButton();
        this.rotation = this.tileStructure.func_189726_i();
        this.updateDirectionButtons();
        this.mode = this.tileStructure.func_189700_k();
        this.updateMode();
        this.ignoreEntities = this.tileStructure.func_189713_m();
        this.updateEntitiesButton();
        this.showAir = this.tileStructure.func_189707_H();
        this.updateToggleAirButton();
        this.showBoundingBox = this.tileStructure.func_189721_I();
        this.updateToggleBoundingBox();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.tileStructure.func_184411_a(this.mirror);
                this.tileStructure.func_184408_a(this.rotation);
                this.tileStructure.func_184405_a(this.mode);
                this.tileStructure.func_184406_a(this.ignoreEntities);
                this.tileStructure.func_189703_e(this.showAir);
                this.tileStructure.func_189710_f(this.showBoundingBox);
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 0) {
                if (this.sendToServer(1)) {
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                }
            } else if (button.field_146127_k == 9) {
                if (this.tileStructure.func_189700_k() == TileEntityStructure.Mode.SAVE) {
                    this.sendToServer(2);
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                }
            } else if (button.field_146127_k == 10) {
                if (this.tileStructure.func_189700_k() == TileEntityStructure.Mode.LOAD) {
                    this.sendToServer(3);
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                }
            } else if (button.field_146127_k == 11) {
                this.tileStructure.func_184408_a(Rotation.NONE);
                this.updateDirectionButtons();
            } else if (button.field_146127_k == 12) {
                this.tileStructure.func_184408_a(Rotation.CLOCKWISE_90);
                this.updateDirectionButtons();
            } else if (button.field_146127_k == 13) {
                this.tileStructure.func_184408_a(Rotation.CLOCKWISE_180);
                this.updateDirectionButtons();
            } else if (button.field_146127_k == 14) {
                this.tileStructure.func_184408_a(Rotation.COUNTERCLOCKWISE_90);
                this.updateDirectionButtons();
            } else if (button.field_146127_k == 18) {
                this.tileStructure.func_189724_l();
                this.updateMode();
            } else if (button.field_146127_k == 19) {
                if (this.tileStructure.func_189700_k() == TileEntityStructure.Mode.SAVE) {
                    this.sendToServer(4);
                    this.field_146297_k.func_147108_a((GuiScreen)null);
                }
            } else if (button.field_146127_k == 20) {
                this.tileStructure.func_184406_a(!this.tileStructure.func_189713_m());
                this.updateEntitiesButton();
            } else if (button.field_146127_k == 22) {
                this.tileStructure.func_189703_e(!this.tileStructure.func_189707_H());
                this.updateToggleAirButton();
            } else if (button.field_146127_k == 23) {
                this.tileStructure.func_189710_f(!this.tileStructure.func_189721_I());
                this.updateToggleBoundingBox();
            } else if (button.field_146127_k == 21) {
                switch (this.tileStructure.func_189716_h()) {
                    case NONE: {
                        this.tileStructure.func_184411_a(Mirror.LEFT_RIGHT);
                        break;
                    }
                    case LEFT_RIGHT: {
                        this.tileStructure.func_184411_a(Mirror.FRONT_BACK);
                        break;
                    }
                    case FRONT_BACK: {
                        this.tileStructure.func_184411_a(Mirror.NONE);
                    }
                }
                this.updateMirrorButton();
            }
        }
    }

    private void updateEntitiesButton() {
        boolean flag = !this.tileStructure.func_189713_m();
        this.showEntitiesButton.field_146126_j = flag ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
    }

    private void updateToggleAirButton() {
        boolean flag = this.tileStructure.func_189707_H();
        this.showAirButton.field_146126_j = flag ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
    }

    private void updateToggleBoundingBox() {
        boolean flag = this.tileStructure.func_189721_I();
        this.showBoundingBoxButton.field_146126_j = flag ? I18n.func_135052_a((String)"options.on", (Object[])new Object[0]) : I18n.func_135052_a((String)"options.off", (Object[])new Object[0]);
    }

    private void updateMirrorButton() {
        Mirror mirror = this.tileStructure.func_189716_h();
        switch (mirror) {
            case NONE: {
                this.mirrorButton.field_146126_j = "|";
                break;
            }
            case LEFT_RIGHT: {
                this.mirrorButton.field_146126_j = "< >";
                break;
            }
            case FRONT_BACK: {
                this.mirrorButton.field_146126_j = "^ v";
            }
        }
    }

    private void updateDirectionButtons() {
        this.rotateZeroDegreesButton.field_146124_l = true;
        this.rotateNinetyDegreesButton.field_146124_l = true;
        this.rotate180DegreesButton.field_146124_l = true;
        this.rotate270DegressButton.field_146124_l = true;
        switch (this.tileStructure.func_189726_i()) {
            case NONE: {
                this.rotateZeroDegreesButton.field_146124_l = false;
                break;
            }
            case CLOCKWISE_180: {
                this.rotate180DegreesButton.field_146124_l = false;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                this.rotate270DegressButton.field_146124_l = false;
                break;
            }
            case CLOCKWISE_90: {
                this.rotateNinetyDegreesButton.field_146124_l = false;
            }
        }
    }

    private void updateMode() {
        this.nameEdit.func_146195_b(false);
        this.posXEdit.func_146195_b(false);
        this.posYEdit.func_146195_b(false);
        this.posZEdit.func_146195_b(false);
        this.sizeXEdit.func_146195_b(false);
        this.sizeYEdit.func_146195_b(false);
        this.sizeZEdit.func_146195_b(false);
        this.integrityEdit.func_146195_b(false);
        this.seedEdit.func_146195_b(false);
        this.dataEdit.func_146195_b(false);
        this.nameEdit.func_146189_e(false);
        this.nameEdit.func_146195_b(false);
        this.posXEdit.func_146189_e(false);
        this.posYEdit.func_146189_e(false);
        this.posZEdit.func_146189_e(false);
        this.sizeXEdit.func_146189_e(false);
        this.sizeYEdit.func_146189_e(false);
        this.sizeZEdit.func_146189_e(false);
        this.integrityEdit.func_146189_e(false);
        this.seedEdit.func_146189_e(false);
        this.dataEdit.func_146189_e(false);
        this.saveButton.field_146125_m = false;
        this.loadButton.field_146125_m = false;
        this.detectSizeButton.field_146125_m = false;
        this.showEntitiesButton.field_146125_m = false;
        this.mirrorButton.field_146125_m = false;
        this.rotateZeroDegreesButton.field_146125_m = false;
        this.rotateNinetyDegreesButton.field_146125_m = false;
        this.rotate180DegreesButton.field_146125_m = false;
        this.rotate270DegressButton.field_146125_m = false;
        this.showAirButton.field_146125_m = false;
        this.showBoundingBoxButton.field_146125_m = false;
        switch (this.tileStructure.func_189700_k()) {
            case SAVE: {
                this.nameEdit.func_146189_e(true);
                this.nameEdit.func_146195_b(true);
                this.posXEdit.func_146189_e(true);
                this.posYEdit.func_146189_e(true);
                this.posZEdit.func_146189_e(true);
                this.sizeXEdit.func_146189_e(true);
                this.sizeYEdit.func_146189_e(true);
                this.sizeZEdit.func_146189_e(true);
                this.saveButton.field_146125_m = true;
                this.detectSizeButton.field_146125_m = true;
                this.showEntitiesButton.field_146125_m = true;
                this.showAirButton.field_146125_m = true;
                break;
            }
            case LOAD: {
                this.nameEdit.func_146189_e(true);
                this.nameEdit.func_146195_b(true);
                this.posXEdit.func_146189_e(true);
                this.posYEdit.func_146189_e(true);
                this.posZEdit.func_146189_e(true);
                this.integrityEdit.func_146189_e(true);
                this.seedEdit.func_146189_e(true);
                this.loadButton.field_146125_m = true;
                this.showEntitiesButton.field_146125_m = true;
                this.mirrorButton.field_146125_m = true;
                this.rotateZeroDegreesButton.field_146125_m = true;
                this.rotateNinetyDegreesButton.field_146125_m = true;
                this.rotate180DegreesButton.field_146125_m = true;
                this.rotate270DegressButton.field_146125_m = true;
                this.showBoundingBoxButton.field_146125_m = true;
                this.updateDirectionButtons();
                break;
            }
            case CORNER: {
                this.nameEdit.func_146189_e(true);
                this.nameEdit.func_146195_b(true);
                break;
            }
            case DATA: {
                this.dataEdit.func_146189_e(true);
                this.dataEdit.func_146195_b(true);
            }
        }
        this.modeButton.field_146126_j = I18n.func_135052_a((String)("structure_block.mode." + this.tileStructure.func_189700_k().func_176610_l()), (Object[])new Object[0]);
    }

    private boolean sendToServer(int type) {
        try {
            PacketSyncStructureBlock packet = new PacketSyncStructureBlock();
            packet.pos = this.tileStructure.func_174877_v();
            packet.type = (byte)type;
            packet.mode = this.tileStructure.func_189700_k().toString();
            packet.name = this.nameEdit.func_146179_b();
            packet.posX = this.parseCoordinate(this.posXEdit.func_146179_b());
            packet.posY = this.parseCoordinate(this.posYEdit.func_146179_b());
            packet.posZ = this.parseCoordinate(this.posZEdit.func_146179_b());
            packet.sizeX = this.parseCoordinate(this.sizeXEdit.func_146179_b());
            packet.sizeY = this.parseCoordinate(this.sizeYEdit.func_146179_b());
            packet.sizeZ = this.parseCoordinate(this.sizeZEdit.func_146179_b());
            packet.mirror = this.tileStructure.func_189716_h().toString();
            packet.rotation = this.tileStructure.func_189726_i().toString();
            packet.data = this.dataEdit.func_146179_b();
            packet.ignoresEntities = this.tileStructure.func_189713_m();
            packet.showsAir = this.tileStructure.func_189707_H();
            packet.showsBoundingBox = this.tileStructure.func_189721_I();
            packet.integrity = this.parseIntegrity(this.integrityEdit.func_146179_b());
            packet.seed = this.parseSeed(this.seedEdit.func_146179_b());
            LimitlessStructureBlocks.network.sendToServer((IMessage)packet);
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn("Could not send structure block info", (Throwable)exception);
            return false;
        }
    }

    private long parseSeed(String p_189821_1_) {
        try {
            return Long.valueOf(p_189821_1_);
        }
        catch (NumberFormatException var3) {
            return 0L;
        }
    }

    private float parseIntegrity(String p_189819_1_) {
        try {
            return Float.valueOf(p_189819_1_).floatValue();
        }
        catch (NumberFormatException var3) {
            return 1.0f;
        }
    }

    private int parseCoordinate(String p_189817_1_) {
        try {
            return Integer.parseInt(p_189817_1_);
        }
        catch (NumberFormatException var3) {
            return 0;
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.nameEdit.func_146176_q() && GuiEditStructureOverride.isValidCharacterForName(typedChar, keyCode)) {
            this.nameEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.posXEdit.func_146176_q()) {
            this.posXEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.posYEdit.func_146176_q()) {
            this.posYEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.posZEdit.func_146176_q()) {
            this.posZEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.sizeXEdit.func_146176_q()) {
            this.sizeXEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.sizeYEdit.func_146176_q()) {
            this.sizeYEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.sizeZEdit.func_146176_q()) {
            this.sizeZEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.integrityEdit.func_146176_q()) {
            this.integrityEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.seedEdit.func_146176_q()) {
            this.seedEdit.func_146201_a(typedChar, keyCode);
        }
        if (this.dataEdit.func_146176_q()) {
            this.dataEdit.func_146201_a(typedChar, keyCode);
        }
        if (keyCode == 15) {
            GuiTextField guitextfield = null;
            GuiTextField guitextfield1 = null;
            for (GuiTextField guitextfield2 : this.tabOrder) {
                if (guitextfield != null && guitextfield2.func_146176_q()) {
                    guitextfield1 = guitextfield2;
                    break;
                }
                if (!guitextfield2.func_146206_l() || !guitextfield2.func_146176_q()) continue;
                guitextfield = guitextfield2;
            }
            if (guitextfield != null && guitextfield1 == null) {
                for (GuiTextField guitextfield3 : this.tabOrder) {
                    if (!guitextfield3.func_146176_q() || guitextfield3 == guitextfield) continue;
                    guitextfield1 = guitextfield3;
                    break;
                }
            }
            if (guitextfield1 != null && guitextfield1 != guitextfield) {
                guitextfield.func_146195_b(false);
                guitextfield1.func_146195_b(true);
            }
        }
        if (keyCode != 28 && keyCode != 156) {
            if (keyCode == 1) {
                this.func_146284_a(this.cancelButton);
            }
        } else {
            this.func_146284_a(this.doneButton);
        }
    }

    private static boolean isValidCharacterForName(char p_190301_0_, int p_190301_1_) {
        boolean flag = true;
        for (int i : LEGAL_KEY_CODES) {
            if (i != p_190301_1_) continue;
            return true;
        }
        for (char c0 : ChatAllowedCharacters.field_189861_b) {
            if (c0 != p_190301_0_) continue;
            flag = false;
            break;
        }
        return flag;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.nameEdit.func_146176_q()) {
            this.nameEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.posXEdit.func_146176_q()) {
            this.posXEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.posYEdit.func_146176_q()) {
            this.posYEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.posZEdit.func_146176_q()) {
            this.posZEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.sizeXEdit.func_146176_q()) {
            this.sizeXEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.sizeYEdit.func_146176_q()) {
            this.sizeYEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.sizeZEdit.func_146176_q()) {
            this.sizeZEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.integrityEdit.func_146176_q()) {
            this.integrityEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.seedEdit.func_146176_q()) {
            this.seedEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.dataEdit.func_146176_q()) {
            this.dataEdit.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        TileEntityStructure.Mode tileentitystructure$mode = this.tileStructure.func_189700_k();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"tile.structureBlock.name", (Object[])new Object[0]), this.field_146294_l / 2, 10, 0xFFFFFF);
        if (tileentitystructure$mode != TileEntityStructure.Mode.DATA) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"structure_block.structure_name", (Object[])new Object[0]), this.field_146294_l / 2 - 153, 30, 0xA0A0A0);
            this.nameEdit.func_146194_f();
        }
        if (tileentitystructure$mode == TileEntityStructure.Mode.LOAD || tileentitystructure$mode == TileEntityStructure.Mode.SAVE) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"structure_block.position", (Object[])new Object[0]), this.field_146294_l / 2 - 153, 70, 0xA0A0A0);
            this.posXEdit.func_146194_f();
            this.posYEdit.func_146194_f();
            this.posZEdit.func_146194_f();
            String s = I18n.func_135052_a((String)"structure_block.include_entities", (Object[])new Object[0]);
            int i = this.field_146289_q.func_78256_a(s);
            this.func_73731_b(this.field_146289_q, s, this.field_146294_l / 2 + 154 - i, 150, 0xA0A0A0);
        }
        if (tileentitystructure$mode == TileEntityStructure.Mode.SAVE) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"structure_block.size", (Object[])new Object[0]), this.field_146294_l / 2 - 153, 110, 0xA0A0A0);
            this.sizeXEdit.func_146194_f();
            this.sizeYEdit.func_146194_f();
            this.sizeZEdit.func_146194_f();
            String s2 = I18n.func_135052_a((String)"structure_block.detect_size", (Object[])new Object[0]);
            int k = this.field_146289_q.func_78256_a(s2);
            this.func_73731_b(this.field_146289_q, s2, this.field_146294_l / 2 + 154 - k, 110, 0xA0A0A0);
            String s1 = I18n.func_135052_a((String)"structure_block.show_air", (Object[])new Object[0]);
            int j = this.field_146289_q.func_78256_a(s1);
            this.func_73731_b(this.field_146289_q, s1, this.field_146294_l / 2 + 154 - j, 70, 0xA0A0A0);
        }
        if (tileentitystructure$mode == TileEntityStructure.Mode.LOAD) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"structure_block.integrity", (Object[])new Object[0]), this.field_146294_l / 2 - 153, 110, 0xA0A0A0);
            this.integrityEdit.func_146194_f();
            this.seedEdit.func_146194_f();
            String s3 = I18n.func_135052_a((String)"structure_block.show_boundingbox", (Object[])new Object[0]);
            int l = this.field_146289_q.func_78256_a(s3);
            this.func_73731_b(this.field_146289_q, s3, this.field_146294_l / 2 + 154 - l, 70, 0xA0A0A0);
        }
        if (tileentitystructure$mode == TileEntityStructure.Mode.DATA) {
            this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"structure_block.custom_data", (Object[])new Object[0]), this.field_146294_l / 2 - 153, 110, 0xA0A0A0);
            this.dataEdit.func_146194_f();
        }
        String s4 = "structure_block.mode_info." + tileentitystructure$mode.func_176610_l();
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)s4, (Object[])new Object[0]), this.field_146294_l / 2 - 153, 174, 0xA0A0A0);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }
}

