/*
 * Decompiled with CFR 0.152.
 */
package turkey.witherCrumbs.entities;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import ganymedes01.headcrumbs.api.IHumanEntity;
import ganymedes01.headcrumbs.entity.EntityHuman;
import ganymedes01.headcrumbs.utils.ThreadedProfileFiller;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import turkey.witherCrumbs.config.WitherCrumbSettings;
import turkey.witherCrumbs.info.CelebrityWitherInfo;
import turkey.witherCrumbs.info.CelebrityWitherRegistry;
import turkey.witherCrumbs.items.WitherCrumbsItems;

public class EntityHumanWither
extends EntityWither
implements IHumanEntity {
    private static final DataParameter<String> NAME = EntityDataManager.func_187226_a(EntityHumanWither.class, (DataSerializer)DataSerializers.field_187194_d);
    private GameProfile profile;
    private boolean isProfileReady;
    private ResourceLocation skinTexture;
    private boolean isRealWither;

    public EntityHumanWither(World world) {
        super(world);
    }

    public void setRealWither(boolean realWither) {
        this.isRealWither = realWither;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(NAME, (Object)"");
    }

    protected void func_70628_a(boolean wasRecentlyHit, int lootingModifier) {
        CelebrityWitherInfo info;
        EntityItem entityItem;
        if ((this.isRealWither || WitherCrumbSettings.dropNetherStar) && (entityItem = this.func_145779_a(Items.field_151156_bN, 1)) != null) {
            entityItem.func_174873_u();
        }
        ItemStack stack = (info = CelebrityWitherRegistry.getCelebrityInfo(this.profile.getName())) == null ? new ItemStack((Item)WitherCrumbsItems.crumbStar) : info.getDropStack();
        this.func_70099_a(stack, 0.0f);
        if (!this.field_70170_p.field_72995_K) {
            for (EntityPlayerMP entityplayermp : this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.func_174813_aQ().func_186662_g(50.0))) {
                CriteriaTriggers.field_192133_m.func_192229_a(entityplayermp, (Entity)this);
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        String username = (String)this.field_70180_af.func_187225_a(NAME);
        if (!StringUtils.func_151246_b((String)username)) {
            tagCompound.func_74778_a("Username", username);
        }
        tagCompound.func_74757_a("IsRealWither", this.isRealWither);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        if (tagCompound.func_74764_b("Username")) {
            this.setUsername(tagCompound.func_74779_i("Username"));
        } else {
            this.setUsername(EntityHuman.getRandomUsername((Random)this.field_70146_Z));
        }
        this.isRealWither = tagCompound.func_74767_n("IsRealWither");
    }

    public ITextComponent func_145748_c_() {
        TextComponentString textComponent = this.profile != null ? new TextComponentString("- " + this.profile.getName() + " -") : new TextComponentString("- WitherCrumb - ");
        textComponent.func_150256_b().func_150209_a(this.func_174823_aP());
        textComponent.func_150256_b().func_179989_a(this.func_189512_bd());
        return textComponent;
    }

    public String getUsername() {
        return (String)this.field_70180_af.func_187225_a(NAME);
    }

    public void setUsername(String name) {
        this.field_70180_af.func_187227_b(NAME, (Object)name);
        this.getProfile();
    }

    public double getInterpolatedCapeX(float v) {
        return 0.0;
    }

    public double getInterpolatedCapeY(float v) {
        return 0.0;
    }

    public double getInterpolatedCapeZ(float v) {
        return 0.0;
    }

    @SideOnly(value=Side.CLIENT)
    public SkinManager.SkinAvailableCallback getCallback() {
        return new SkinManager.SkinAvailableCallback(){

            public void func_180521_a(MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                if (type == MinecraftProfileTexture.Type.SKIN) {
                    EntityHumanWither.this.skinTexture = location;
                }
            }
        };
    }

    public boolean isTextureAvailable(MinecraftProfileTexture.Type type) {
        return type == MinecraftProfileTexture.Type.SKIN && this.skinTexture != null;
    }

    public ResourceLocation getTexture(MinecraftProfileTexture.Type type) {
        return this.skinTexture;
    }

    public boolean isProfileReady() {
        return this.isProfileReady;
    }

    @Nullable
    public GameProfile getProfile() {
        if (this.profile == null) {
            this.profile = new GameProfile(null, (String)this.field_70180_af.func_187225_a(NAME));
            ThreadedProfileFiller.updateProfile((IHumanEntity)this);
        }
        return this.profile;
    }

    public void setProfile(GameProfile profile) {
        this.profile = profile;
        this.field_184744_bE.func_186739_a(this.func_145748_c_());
        this.isProfileReady = true;
    }
}

