/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.action;

import codersafterdark.reskillable.api.ReskillableRegistries;
import codersafterdark.reskillable.api.data.PlayerData;
import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import codersafterdark.reskillable.api.event.UnlockUnlockableEvent;
import codersafterdark.reskillable.api.requirement.RequirementCache;
import codersafterdark.reskillable.api.requirement.TraitRequirement;
import codersafterdark.reskillable.api.skill.Skill;
import codersafterdark.reskillable.api.toast.ToastHelper;
import codersafterdark.reskillable.api.unlockable.Unlockable;
import com.buuz135.togetherforever.action.recovery.ReskillableUnlockableOfflineRecovery;
import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.action.EventSyncAction;
import com.buuz135.togetherforever.api.annotation.SyncAction;
import com.buuz135.togetherforever.config.TogetherForeverConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

@SyncAction(id="reskillable_unlockable_event_sync", dependencies={"reskillable"})
public class ReskillableUnlockableSyncAction
extends EventSyncAction<UnlockUnlockableEvent.Post, ReskillableUnlockableOfflineRecovery> {
    public ReskillableUnlockableSyncAction() {
        super(UnlockUnlockableEvent.Post.class, ReskillableUnlockableOfflineRecovery.class);
    }

    @Override
    public NBTTagCompound transformEventToNBT(UnlockUnlockableEvent.Post event) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("Unlock", event.getUnlockable().getRegistryName().toString());
        return tagCompound;
    }

    @Override
    public List<IPlayerInformation> triggerSync(UnlockUnlockableEvent.Post object, ITogetherTeam togetherTeam) {
        ArrayList<IPlayerInformation> playerInformations = new ArrayList<IPlayerInformation>();
        if (!TogetherForeverConfig.reskillableUnlockableSync) {
            return playerInformations;
        }
        for (IPlayerInformation information : togetherTeam.getPlayers()) {
            Unlockable unlockable;
            PlayerData data;
            PlayerSkillInfo skillInfo;
            EntityPlayerMP playerMP = information.getPlayer();
            if (playerMP == null) {
                playerInformations.add(information);
                continue;
            }
            if (playerMP.func_110124_au().equals(object.getEntityPlayer().func_110124_au()) || (skillInfo = (data = PlayerDataHandler.get((EntityPlayer)playerMP)).getSkillInfo((unlockable = object.getUnlockable()).getParentSkill())).isUnlocked(unlockable)) continue;
            skillInfo.unlock(unlockable, (EntityPlayer)playerMP);
            data.saveAndSync();
            RequirementCache.invalidateCache((UUID)information.getUUID(), (Class[])new Class[]{TraitRequirement.class});
            ToastHelper.sendUnlockableToast((EntityPlayerMP)information.getPlayer(), (Unlockable)unlockable);
        }
        return playerInformations;
    }

    @Override
    public void syncJoinPlayer(IPlayerInformation toBeSynced, IPlayerInformation teamMember) {
        if (!TogetherForeverConfig.reskillableUnlockableSync) {
            return;
        }
        if (toBeSynced.getPlayer() != null && teamMember.getPlayer() != null) {
            PlayerData origin = PlayerDataHandler.get((EntityPlayer)teamMember.getPlayer());
            PlayerData sync = PlayerDataHandler.get((EntityPlayer)toBeSynced.getPlayer());
            boolean changed = false;
            for (Skill skill : ReskillableRegistries.SKILLS.getValuesCollection()) {
                PlayerSkillInfo originSkillInfo = origin.getSkillInfo(skill);
                PlayerSkillInfo syncSkillInfo = sync.getSkillInfo(skill);
                for (Unlockable unlockable : skill.getUnlockables()) {
                    if (!originSkillInfo.isUnlocked(unlockable) || syncSkillInfo.isUnlocked(unlockable)) continue;
                    syncSkillInfo.unlock(unlockable, (EntityPlayer)toBeSynced.getPlayer());
                    changed = true;
                    ToastHelper.sendUnlockableToast((EntityPlayerMP)toBeSynced.getPlayer(), (Unlockable)unlockable);
                }
            }
            if (changed) {
                sync.saveAndSync();
                RequirementCache.invalidateCache((UUID)toBeSynced.getUUID(), (Class[])new Class[]{TraitRequirement.class});
            }
            origin.saveAndSync();
        }
    }
}

