/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.togetherforever.api.data;

import com.buuz135.togetherforever.api.IPlayerInformation;
import com.buuz135.togetherforever.api.ISyncAction;
import com.buuz135.togetherforever.api.ITogetherTeam;
import com.buuz135.togetherforever.api.TogetherForeverAPI;
import com.buuz135.togetherforever.api.data.DefaultTogetherTeam;
import com.buuz135.togetherforever.api.data.TogetherRegistries;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class TeamInvite {
    private final IPlayerInformation sender;
    private final IPlayerInformation receiver;
    private long createdTime;

    public TeamInvite(IPlayerInformation sender, IPlayerInformation receiver) {
        this.sender = sender;
        this.receiver = receiver;
        this.createdTime = System.currentTimeMillis();
    }

    public IPlayerInformation getSender() {
        return this.sender;
    }

    public IPlayerInformation getReciever() {
        return this.receiver;
    }

    public void acceptInvite(boolean announce, boolean syncActions) {
        ITogetherTeam team = TogetherForeverAPI.getInstance().getPlayerTeam(this.sender.getUUID());
        if (team == null) {
            team = new DefaultTogetherTeam();
            team.addPlayer(this.sender);
            TogetherForeverAPI.getInstance().addTeam(team);
        }
        if (announce) {
            for (IPlayerInformation iPlayerInformation : team.getPlayers()) {
                if (iPlayerInformation.getPlayer() == null) continue;
                iPlayerInformation.getPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + this.receiver.getName() + " has joined your team."));
            }
            if (this.receiver.getPlayer() != null) {
                this.receiver.getPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You have joined " + this.sender.getName() + "'s team."));
            }
        }
        if (syncActions) {
            for (ISyncAction iSyncAction : TogetherRegistries.getSyncActions()) {
                iSyncAction.syncJoinPlayer(this.receiver, this.sender);
            }
        }
        TogetherForeverAPI.getInstance().addPlayerToTeam(team, this.receiver);
    }
}

