/*
 * Decompiled with CFR 0.152.
 */
package shadows.click.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import shadows.click.util.NetHandlerSpaghettiServer;

@Mod.EventBusSubscriber
public class FakePlayerUtil {
    private static final Map<Pair<GameProfile, Integer>, UsefulFakePlayer> PLAYERS = new HashMap<Pair<GameProfile, Integer>, UsefulFakePlayer>();

    public static UsefulFakePlayer getPlayer(World world, GameProfile profile) {
        return PLAYERS.computeIfAbsent((Pair<GameProfile, Integer>)Pair.of((Object)profile, (Object)world.field_73011_w.getDimension()), p -> {
            UsefulFakePlayer player = new UsefulFakePlayer(world, (GameProfile)p.getLeft());
            player.field_71135_a = new NetHandlerSpaghettiServer(player);
            return player;
        });
    }

    @SubscribeEvent
    public static void unload(WorldEvent.Unload e) {
        PLAYERS.entrySet().removeIf(entry -> ((UsefulFakePlayer)((Object)((Object)entry.getValue()))).field_70170_p == e.getWorld());
    }

    public static void setupFakePlayerForUse(UsefulFakePlayer player, BlockPos pos, EnumFacing direction, ItemStack toHold, boolean sneaking) {
        float pitch;
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)toHold);
        float f = direction == EnumFacing.UP ? -90.0f : (pitch = direction == EnumFacing.DOWN ? 90.0f : 0.0f);
        float yaw = direction == EnumFacing.SOUTH ? 0.0f : (direction == EnumFacing.WEST ? 90.0f : (direction == EnumFacing.NORTH ? 180.0f : -90.0f));
        Vec3i sideVec = direction.func_176730_m();
        EnumFacing.Axis a = direction.func_176740_k();
        EnumFacing.AxisDirection ad = direction.func_176743_c();
        double x = a == EnumFacing.Axis.X && ad == EnumFacing.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.func_177958_n() / 1.9;
        double y = 0.5 + (double)sideVec.func_177956_o() / 1.9;
        double z = a == EnumFacing.Axis.Z && ad == EnumFacing.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.func_177952_p() / 1.9;
        player.func_70012_b((double)pos.func_177958_n() + x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + z, yaw, pitch);
        if (!toHold.func_190926_b()) {
            player.func_110140_aT().func_111147_b(toHold.func_111283_C(EntityEquipmentSlot.MAINHAND));
        }
        player.func_70095_a(sneaking);
    }

    public static void cleanupFakePlayerFromUse(UsefulFakePlayer player, ItemStack resultStack, ItemStack oldStack, Consumer<ItemStack> stackCallback) {
        if (!oldStack.func_190926_b()) {
            player.func_110140_aT().func_111148_a(oldStack.func_111283_C(EntityEquipmentSlot.MAINHAND));
        }
        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
        stackCallback.accept(resultStack);
        if (!player.field_71071_by.func_191420_l()) {
            player.field_71071_by.func_70436_m();
        }
        player.func_70095_a(false);
    }

    public static ItemStack rightClickInDirection(UsefulFakePlayer player, World world, BlockPos pos, EnumFacing side, IBlockState sourceState) {
        float f2;
        float f1;
        float f;
        EnumActionResult enumactionresult;
        BlockPos blockpos;
        IBlockState state;
        RayTraceResult toUse;
        Vec3d base = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        Vec3d look = player.func_70040_Z();
        Vec3d target = base.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
        RayTraceResult trace = world.func_147447_a(base, target, false, false, true);
        RayTraceResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, world);
        RayTraceResult rayTraceResult = toUse = trace == null ? traceEntity : trace;
        if (trace != null && traceEntity != null) {
            double d1 = trace.field_72307_f.func_72438_d(base);
            double d2 = traceEntity.field_72307_f.func_72438_d(base);
            RayTraceResult rayTraceResult2 = toUse = traceEntity.field_72313_a == RayTraceResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        if (toUse == null) {
            return player.func_184614_ca();
        }
        ItemStack itemstack = player.func_184614_ca();
        if (toUse.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, toUse.field_72308_g, toUse, CPacketUseEntity.Action.INTERACT_AT)) {
                return player.func_184614_ca();
            }
            if (FakePlayerUtil.processUseEntity(player, world, toUse.field_72308_g, null, CPacketUseEntity.Action.INTERACT)) {
                return player.func_184614_ca();
            }
        } else if (toUse.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(blockpos = toUse.func_178782_a())) != sourceState && state.func_185904_a() != Material.field_151579_a && (enumactionresult = player.field_71134_c.func_187251_a((EntityPlayer)player, world, itemstack, EnumHand.MAIN_HAND, blockpos, toUse.field_178784_b, f = (float)(toUse.field_72307_f.field_72450_a - (double)pos.func_177958_n()), f1 = (float)(toUse.field_72307_f.field_72448_b - (double)pos.func_177956_o()), f2 = (float)(toUse.field_72307_f.field_72449_c - (double)pos.func_177952_p()))) == EnumActionResult.SUCCESS) {
            return player.func_184614_ca();
        }
        if (toUse == null || toUse.field_72313_a == RayTraceResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.func_180495_p(pos.func_177967_a(side, i));
                if (state == sourceState || state.func_185904_a() == Material.field_151579_a) continue;
                player.field_71134_c.func_187251_a((EntityPlayer)player, world, itemstack, EnumHand.MAIN_HAND, pos.func_177967_a(side, i), toUse.field_178784_b, 0.0f, 0.0f, 0.0f);
                return player.func_184614_ca();
            }
        }
        if (itemstack.func_190926_b() && (toUse == null || toUse.field_72313_a == RayTraceResult.Type.MISS)) {
            ForgeHooks.onEmptyClick((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND);
        }
        if (!itemstack.func_190926_b()) {
            player.field_71134_c.func_187250_a((EntityPlayer)player, world, itemstack, EnumHand.MAIN_HAND);
        }
        return player.func_184614_ca();
    }

    public static ItemStack leftClickInDirection(UsefulFakePlayer player, World world, BlockPos pos, EnumFacing side, IBlockState sourceState) {
        BlockPos blockpos;
        IBlockState state;
        RayTraceResult toUse;
        Vec3d base = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        Vec3d look = player.func_70040_Z();
        Vec3d target = base.func_72441_c(look.field_72450_a * 5.0, look.field_72448_b * 5.0, look.field_72449_c * 5.0);
        RayTraceResult trace = world.func_147447_a(base, target, false, false, true);
        RayTraceResult traceEntity = FakePlayerUtil.traceEntities(player, base, target, world);
        RayTraceResult rayTraceResult = toUse = trace == null ? traceEntity : trace;
        if (trace != null && traceEntity != null) {
            double d1 = trace.field_72307_f.func_72438_d(base);
            double d2 = traceEntity.field_72307_f.func_72438_d(base);
            RayTraceResult rayTraceResult2 = toUse = traceEntity.field_72313_a == RayTraceResult.Type.ENTITY && d1 > d2 ? traceEntity : trace;
        }
        if (toUse == null) {
            return player.func_184614_ca();
        }
        ItemStack itemstack = player.func_184614_ca();
        if (toUse.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (FakePlayerUtil.processUseEntity(player, world, toUse.field_72308_g, null, CPacketUseEntity.Action.ATTACK)) {
                return player.func_184614_ca();
            }
        } else if (toUse.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(blockpos = toUse.func_178782_a())) != sourceState && state.func_185904_a() != Material.field_151579_a) {
            player.field_71134_c.func_180784_a(blockpos, toUse.field_178784_b);
            return player.func_184614_ca();
        }
        if (toUse == null || toUse.field_72313_a == RayTraceResult.Type.MISS) {
            for (int i = 1; i <= 5; ++i) {
                state = world.func_180495_p(pos.func_177967_a(side, i));
                if (state == sourceState || state.func_185904_a() == Material.field_151579_a) continue;
                player.field_71134_c.func_180784_a(pos.func_177967_a(side, i), side.func_176734_d());
                return player.func_184614_ca();
            }
        }
        if (itemstack.func_190926_b() && (toUse == null || toUse.field_72313_a == RayTraceResult.Type.MISS)) {
            ForgeHooks.onEmptyLeftClick((EntityPlayer)player);
        }
        return player.func_184614_ca();
    }

    public static RayTraceResult traceEntities(UsefulFakePlayer player, Vec3d base, Vec3d target, World world) {
        Entity pointedEntity = null;
        RayTraceResult result = null;
        Vec3d vec3d3 = null;
        AxisAlignedBB search = new AxisAlignedBB(base.field_72450_a, base.field_72448_b, base.field_72449_c, target.field_72450_a, target.field_72448_b, target.field_72449_c).func_72314_b(0.5, 0.5, 0.5);
        List list = world.func_175674_a((Entity)player, search, Predicates.and((Predicate)EntitySelectors.field_180132_d, entity -> entity != null && entity.func_70067_L()));
        double d2 = 5.0;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AxisAlignedBB aabb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            RayTraceResult raytraceresult = aabb.func_72327_a(base, target);
            if (aabb.func_72318_a(base)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult == null ? base : raytraceresult.field_72307_f;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = base.func_72438_d(raytraceresult.field_72307_f)) < d2) && d2 != 0.0) continue;
            if (entity1.func_184208_bv() == player.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                vec3d3 = raytraceresult.field_72307_f;
                continue;
            }
            pointedEntity = entity1;
            vec3d3 = raytraceresult.field_72307_f;
            d2 = d3;
        }
        if (pointedEntity != null && base.func_72438_d(vec3d3) > 5.0) {
            pointedEntity = null;
            result = new RayTraceResult(RayTraceResult.Type.MISS, vec3d3, (EnumFacing)null, new BlockPos(vec3d3));
        }
        if (pointedEntity != null) {
            result = new RayTraceResult(pointedEntity, vec3d3);
        }
        return result;
    }

    public static boolean processUseEntity(UsefulFakePlayer player, World world, Entity entity, @Nullable RayTraceResult result, CPacketUseEntity.Action action) {
        if (entity != null) {
            boolean flag = player.func_70685_l(entity);
            double d0 = 36.0;
            if (!flag) {
                d0 = 9.0;
            }
            if (player.func_70068_e(entity) < d0) {
                if (action == CPacketUseEntity.Action.INTERACT) {
                    return player.func_190775_a(entity, EnumHand.MAIN_HAND) == EnumActionResult.SUCCESS;
                }
                if (action == CPacketUseEntity.Action.INTERACT_AT) {
                    if (ForgeHooks.onInteractEntityAt((EntityPlayer)player, (Entity)entity, (Vec3d)result.field_72307_f, (EnumHand)EnumHand.MAIN_HAND) != null) {
                        return false;
                    }
                    return entity.func_184199_a((EntityPlayer)player, result.field_72307_f, EnumHand.MAIN_HAND) == EnumActionResult.SUCCESS;
                }
                if (action == CPacketUseEntity.Action.ATTACK) {
                    if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == player) {
                        return false;
                    }
                    player.func_71059_n(entity);
                    return true;
                }
            }
        }
        return false;
    }

    public static RayTraceResult rayTrace(UsefulFakePlayer player, World world, double reachDist, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * reachDist, vec3d1.field_72448_b * reachDist, vec3d1.field_72449_c * reachDist);
        return world.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public static class UsefulFakePlayer
    extends FakePlayer {
        public UsefulFakePlayer(World world, GameProfile name) {
            super((WorldServer)world, name);
        }

        public float func_70047_e() {
            return 0.0f;
        }

        public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        }

        public float func_184825_o(float adjustTicks) {
            return 1.0f;
        }
    }
}

