/*
 * Decompiled with CFR 0.152.
 */
package com.parkermc.advancementbook;

import com.parkermc.advancementbook.proxy.ProxyCommon;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig {
    private static final String CATEGORY_GENERAL = "general";
    public static boolean giveFirstJoin = true;

    public static void readConfig() {
        Configuration cfg = ProxyCommon.config;
        try {
            cfg.load();
            ModConfig.initGeneralConfig(cfg);
        }
        catch (Exception e1) {
            FMLLog.log.error("Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
                cfg.load();
            }
        }
    }

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_GENERAL, "General configuration");
        giveFirstJoin = cfg.getBoolean("giveOnFirstJoin", CATEGORY_GENERAL, giveFirstJoin, "Give the user the advancement book when they first join the world");
    }

    @Mod.EventBusSubscriber
    static class ConfigurationHandler {
        ConfigurationHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("advancementbook") && ProxyCommon.config.hasChanged()) {
                ProxyCommon.config.save();
                ModConfig.readConfig();
            }
        }
    }
}

