/*
 * Decompiled with CFR 0.152.
 */
package com.parkermc.advancementbook.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public class DataHandler {
    private static String folder = "data";
    private static String file = "advancementbook.dat";
    private World world;
    public List<UUID> givenBook = new ArrayList<UUID>();

    public DataHandler(World world) {
        this.world = world;
    }

    public static DataHandler get(World world) {
        DataHandler dh = new DataHandler(world);
        dh.load();
        return dh;
    }

    public void load() {
        if (this.world != null) {
            File filename = Paths.get(this.world.func_72860_G().func_75765_b().getPath(), folder, file).toFile();
            if (filename.exists()) {
                try {
                    FileInputStream fileinputstream = new FileInputStream(filename);
                    NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                    fileinputstream.close();
                    this.readFromNBT(nbttagcompound.func_74775_l("data"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.save();
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.givenBook.clear();
        NBTTagList nbtGivenBook = nbt.func_150295_c("givenBook", 8);
        for (int i = 0; i < nbtGivenBook.func_74745_c(); ++i) {
            this.givenBook.add(UUID.fromString(nbtGivenBook.func_150307_f(i)));
        }
    }

    public void save() {
        if (this.world != null) {
            File filename = Paths.get(this.world.func_72860_G().func_75765_b().getPath(), folder, file).toFile();
            try {
                if (!filename.exists()) {
                    filename.createNewFile();
                }
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74782_a("data", (NBTBase)this.writeToNBT(new NBTTagCompound()));
                FileOutputStream fileoutputstream = new FileOutputStream(filename);
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagList nbtGivenBook = new NBTTagList();
        for (UUID uuid : this.givenBook) {
            nbtGivenBook.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        compound.func_74782_a("givenBook", (NBTBase)nbtGivenBook);
        return compound;
    }
}

