/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Config;

@Config(modid="realfilingcabinet")
public class ConfigRFC {
    @Config.Comment(value={"Configure the folder storage limit for dyed folders."})
    public static int folderSizeLimit = 1000;
    @Config.Comment(value={"If enabled, will let filing cabinets use a different texture depending on the season."})
    public static boolean seasonalCabinets = true;
    @Config.Comment(value={"Disable this if you want WAILA / TheOneProbe to handle the overlay insted."})
    public static boolean magnifyingGlassGui = true;
    @Config.Comment(value={"If enabled, will let Mob Folders with a villager in it spawn villagers with their professions randomized."})
    public static boolean randomVillager = false;
    @Config.Comment(value={"If enabled, will let Fluid Folders place water in the nether."})
    public static boolean waterNether = false;
    @Config.Comment(value={"If disabled, will not let folders pick up dropped items."})
    public static boolean pickupStuff = true;
    @Config.Comment(value={"If enabled, A fluid cabinet containing at least 3000mb of water will never run out of water."})
    public static boolean infiniteWaterSource = true;
    @Config.Comment(value={"Use this to blacklist certain mobs from being captured in the Mob Folder. Put the class names of the entities here."})
    public static String[] mobFolderBlacklist = new String[]{"EntityCabinet"};
    @Config.Comment(value={"List of items that will be randomly picked by the mystery folder."})
    public static String[] mysteryItems = new String[]{"minecraft:diamond", "minecraft:cobblestone", "minecraft:blaze_rod", "minecraft:slime_ball", "minecraft:clay", "minecraft:prismarine", "minecraft:rabbit_foot", "minecraft:torch"};
    @Config.Comment(value={"Sets the upper bound limit of the loot item's stack size that the Mystery Folder will randomly return. Set to 0 to always return a single item every time."})
    public static int maxLootChance = 7;
    @Config.Comment(value={"Adjust placement of magnifying glass GUI on the x axis."})
    public static int guiWidth = 0;
    @Config.Comment(value={"Adjust placement of magnifying glass GUI on the y axis."})
    public static int guiHeight = 5;
    @Config.Comment(value={"If enabled, reverses the interaction of pulling items from filing cabinets, so that shiftclick pulls 1 instead of 64 and vice-versa for without shiftclick."})
    public static boolean invertShift = false;
    @Config.Comment(value={"Displays the current Item/Block being contained in the currently held folder/suitcase"})
    public static boolean folderHud = true;

    public static void checkTappedValues(Class clazz) {
        for (Field f : clazz.getDeclaredFields()) {
            Tap tapped = f.getAnnotation(Tap.class);
            if (tapped != null) {
                try {
                    Map map;
                    Field tapField;
                    Class c = tapped.mapClass();
                    if (c == null || (tapField = c.getDeclaredField(tapped.mapName())) == null || (map = (Map)tapField.get(null)) == null) continue;
                    map.put(f.getName(), f.get(null));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (f.getType().getSuperclass() != Object.class) continue;
            ConfigRFC.checkTappedValues(f.getType());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Tap {
        public Class mapClass() default RecipeConfig.class;

        public String mapName() default "boolean_stuff";
    }

    @Config(modid="realfilingcabinet", category="integration")
    public static class CompatConfig {
        @Config.Comment(value={"If enabled, will add mana cabinets and folders for Botania."})
        public static boolean botaniaIntegration = true;
        @Config.Comment(value={"If enabled, will add cabinets and folders for Thaumcraft."})
        public static boolean tcIntegration = true;
    }

    @Config(modid="realfilingcabinet", category="recipes")
    public static class RecipeConfig {
        @Config.Ignore
        public static HashMap<String, Boolean> boolean_stuff = new HashMap();
        @Config.Comment(value={"Enable Crafting Upgrade recipe"})
        @Tap
        public static boolean craftingUpgrade = true;
        @Config.Comment(value={"Enable Ender Upgrade recipe"})
        @Tap
        public static boolean enderUpgrade = true;
        @Config.Comment(value={"Enable Oredict Upgrade recipe"})
        @Tap
        public static boolean oreDictUpgrade = true;
        @Config.Comment(value={"Enable Mob Upgrade recipe"})
        @Tap
        public static boolean mobUpgrade = true;
        @Config.Comment(value={"Enable Fluid Upgrade recipe"})
        @Tap
        public static boolean fluidUpgrade = true;
        @Config.Comment(value={"Enable Life Upgrade recipe"})
        @Tap
        public static boolean lifeUpgrade = true;
        @Config.Comment(value={"Enable Smelting Upgrade recipe"})
        @Tap
        public static boolean smeltingUpgrade = true;
    }
}

