/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers;

import com.bafomdad.realfilingcabinet.api.IUpgrade;
import com.bafomdad.realfilingcabinet.api.RealFilingCabinetAPI;
import com.bafomdad.realfilingcabinet.api.upgrades.MobUpgrades;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import java.util.LinkedHashSet;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class MobUpgradeHelper {
    private static final LinkedHashSet<MobUpgrades> MOBUPGRADES = RealFilingCabinetAPI.MOBUPGRADES;

    public static boolean hasUpgrade(EntityCabinet entity) {
        if (entity == null) {
            return false;
        }
        return !entity.upgrades.isEmpty();
    }

    public static MobUpgrades getUpgrade(EntityCabinet entity, String tag) {
        if (!MobUpgradeHelper.hasUpgrade(entity)) {
            return MobUpgrades.EMPTY;
        }
        MobUpgrades upgrade = MobUpgradeHelper.getUpgrade(entity);
        return !upgrade.isEmpty() && upgrade.getTag().equals(tag) ? upgrade : MobUpgrades.EMPTY;
    }

    public static MobUpgrades getUpgrade(EntityCabinet entity) {
        Optional<MobUpgrades> opt = MOBUPGRADES.stream().filter(u -> u.getTag().equals(entity.upgrades)).findAny();
        return opt.isPresent() ? opt.get() : MobUpgrades.EMPTY;
    }

    public static void setMobUpgrade(EntityPlayer player, EntityCabinet entity, ItemStack upgrade) {
        if (entity.field_70170_p.field_72995_K || !(upgrade.func_77973_b() instanceof IUpgrade)) {
            return;
        }
        if (MobUpgradeHelper.hasUpgrade(entity)) {
            return;
        }
        MOBUPGRADES.stream().filter(u -> ItemStack.func_179545_c((ItemStack)upgrade, (ItemStack)u.getUpgrade())).findAny().ifPresent(u -> {
            entity.upgrades = u.getTag();
            if (!player.field_71075_bZ.field_75098_d) {
                upgrade.func_190918_g(1);
            }
            entity.setTexture(u.getTexture().toString());
            entity.setModel(u.getModelPath());
        });
    }

    public static void removeMobUpgrade(EntityPlayer player, EntityCabinet entity) {
        if (!MobUpgradeHelper.hasUpgrade(entity)) {
            return;
        }
        MOBUPGRADES.stream().filter(u -> u.getTag().equals(entity.upgrades)).findAny().ifPresent(u -> {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)u.getUpgrade().func_77946_l());
            entity.upgrades = "";
            entity.setTexture("");
            entity.setModel("");
        });
    }
}

