/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public class TextHelper {
    private static final NavigableMap<Long, String> SUFFIXES = new TreeMap<Long, String>();
    private static final NavigableMap<Integer, String> MANASUFFIXES = new TreeMap<Integer, String>();

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return TextHelper.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + TextHelper.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = SUFFIXES.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static String formatMana(int value) {
        Map.Entry<Integer, String> e = MANASUFFIXES.floorEntry(value);
        String suffix = e.getValue();
        return suffix;
    }

    static {
        SUFFIXES.put(1000L, "k");
        SUFFIXES.put(1000000L, "M");
        SUFFIXES.put(1000000000L, "b");
        SUFFIXES.put(1000000000000L, "T");
        SUFFIXES.put(1000000000000000L, "q");
        MANASUFFIXES.put(0, "tooltip.realfilingcabinet.mana0");
        MANASUFFIXES.put(120, "tooltip.realfilingcabinet.mana120");
        MANASUFFIXES.put(500, "tooltip.realfilingcabinet.mana500");
        MANASUFFIXES.put(2500, "tooltip.realfilingcabinet.mana2500");
        MANASUFFIXES.put(3000, "tooltip.realfilingcabinet.mana3000");
        MANASUFFIXES.put(6000, "tooltip.realfilingcabinet.mana6000");
        MANASUFFIXES.put(10000, "tooltip.realfilingcabinet.mana10000");
        MANASUFFIXES.put(15000, "tooltip.realfilingcabinet.mana15000");
        MANASUFFIXES.put(20000, "tooltip.realfilingcabinet.mana20000");
        MANASUFFIXES.put(500000, "tooltip.realfilingcabinet.mana500000");
        MANASUFFIXES.put(1000000, "tooltip.realfilingcabinet.mana1000000");
        MANASUFFIXES.put(10000000, "tooltip.realfilingcabinet.mana10000000");
        MANASUFFIXES.put(100000000, "tooltip.realfilingcabinet.mana10000000");
        MANASUFFIXES.put(1000000000, "tooltip.realfilingcabinet.mana10000000");
    }
}

