/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers;

import com.bafomdad.realfilingcabinet.ConfigRFC;
import com.bafomdad.realfilingcabinet.api.IUpgrade;
import com.bafomdad.realfilingcabinet.api.RealFilingCabinetAPI;
import com.bafomdad.realfilingcabinet.api.upgrades.Upgrades;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.enums.UpgradeType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.LinkedHashSet;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;

public class UpgradeHelper {
    private static final LinkedHashSet<Upgrades> UPGRADES = RealFilingCabinetAPI.UPGRADES;
    private static final ResourceLocation DEFAULT = new ResourceLocation("realfilingcabinet", "textures/model/filingcabinet.png");
    private static final ResourceLocation HALLOWEEN = new ResourceLocation("realfilingcabinet", "textures/model/pumpkincabinet.png");
    private static final ResourceLocation CHRISTMAS = new ResourceLocation("realfilingcabinet", "textures/model/candycanecabinet.png");

    public static boolean hasUpgrade(TileFilingCabinet tile) {
        if (tile == null) {
            return false;
        }
        return !tile.upgrade.isEmpty();
    }

    public static boolean isCreative(TileEntityRFC tile) {
        return tile.isCreative;
    }

    public static Upgrades getUpgrade(TileFilingCabinet tile, String tag) {
        if (!UpgradeHelper.hasUpgrade(tile)) {
            return Upgrades.EMPTY;
        }
        Upgrades upgrade = UpgradeHelper.getUpgrade(tile);
        return !upgrade.isEmpty() && upgrade.getTag().equals(tag) ? upgrade : Upgrades.EMPTY;
    }

    public static Upgrades getUpgrade(TileFilingCabinet tile) {
        Optional<Upgrades> opt = UPGRADES.stream().filter(u -> u.getTag().equals(tile.upgrade)).findAny();
        return opt.isPresent() ? opt.get() : Upgrades.EMPTY;
    }

    public static void setUpgrade(EntityPlayer player, TileFilingCabinet tile, ItemStack upgrade) {
        if (tile.func_145831_w().field_72995_K || !(upgrade.func_77973_b() instanceof IUpgrade)) {
            return;
        }
        if (!((IUpgrade)upgrade.func_77973_b()).canApply(upgrade, player)) {
            return;
        }
        UPGRADES.stream().filter(u -> ItemStack.func_179545_c((ItemStack)upgrade, (ItemStack)u.getUpgrade())).findAny().ifPresent(u -> {
            if (u.getTag().equals("TAG_creativeUpgrade")) {
                if (UpgradeHelper.isCreative(tile)) {
                    return;
                }
                tile.isCreative = true;
                if (!player.field_71075_bZ.field_75098_d) {
                    upgrade.func_190918_g(1);
                }
                tile.func_70296_d();
                return;
            }
            if (UpgradeHelper.hasUpgrade(tile)) {
                return;
            }
            tile.upgrade = u.getTag();
            if (!player.field_71075_bZ.field_75098_d) {
                upgrade.func_190918_g(1);
            }
            if (upgrade.func_77973_b() == RFCItems.UPGRADE && upgrade.func_77952_i() == UpgradeType.ENDER.ordinal()) {
                tile.setHash();
            }
            tile.func_70296_d();
        });
    }

    public static void removeUpgrade(EntityPlayer player, TileFilingCabinet tile) {
        if (!UpgradeHelper.hasUpgrade(tile) && !UpgradeHelper.isCreative(tile)) {
            return;
        }
        UPGRADES.stream().filter(u -> tile.isCreative || u.getTag().equals(tile.upgrade)).findAny().ifPresent(u -> {
            if (tile.isCreative) {
                tile.isCreative = false;
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack(RFCItems.UPGRADE, 1, 0));
                tile.func_70296_d();
                return;
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)u.getUpgrade().func_77946_l());
            tile.upgrade = "";
            tile.func_70296_d();
        });
    }

    public static ResourceLocation getTexture(TileFilingCabinet tile) {
        Optional<Upgrades> opt = UPGRADES.stream().filter(u -> u.getTag().equals(tile.upgrade)).findAny();
        return opt.isPresent() && opt.get().getTexture() != null ? opt.get().getTexture() : UpgradeHelper.getDefault();
    }

    private static ResourceLocation getDefault() {
        if (ConfigRFC.seasonalCabinets) {
            LocalDateTime current = LocalDateTime.now();
            if (current.getMonth() == Month.OCTOBER) {
                return HALLOWEEN;
            }
            if (current.getMonth() == Month.DECEMBER) {
                return CHRISTMAS;
            }
        }
        return DEFAULT;
    }
}

