/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.api.IBlockCabinet;
import com.bafomdad.realfilingcabinet.api.IEmptyFolder;
import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemSuitcase;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityProviderFolder;
import com.bafomdad.realfilingcabinet.utils.StorageUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public final class FolderUtils {
    final Optional<CapabilityFolder> cap;

    private FolderUtils(ItemStack stack) {
        CapabilityFolder folderCap = (CapabilityFolder)stack.getCapability(CapabilityProviderFolder.FOLDER_CAP, null);
        this.cap = folderCap != null ? Optional.of(folderCap) : Optional.empty();
    }

    public static FolderUtils get(ItemStack stack) {
        if (stack.func_77973_b() == RFCItems.SUITCASE) {
            return FolderUtils.getSuitcase(stack);
        }
        return new FolderUtils(stack);
    }

    public static FolderUtils getSuitcase(ItemStack suitcase) {
        ItemStack folder = ItemStack.field_190927_a;
        IItemHandlerModifiable suitcaseInv = ItemSuitcase.getSuitcaseInv(suitcase);
        if (suitcaseInv != null) {
            folder = suitcaseInv.getStackInSlot(StorageUtils.getIndex(suitcase));
        }
        return new FolderUtils(folder);
    }

    public CapabilityFolder getCap() {
        return this.cap.isPresent() ? this.cap.get() : null;
    }

    public void addTooltips(List<String> list, boolean crouching) {
        this.cap.ifPresent(c -> c.addTooltips(list, crouching));
    }

    public long getFileSize() {
        return this.cap.isPresent() ? this.cap.get().getCount() : 0L;
    }

    public void setFileSize(long count) {
        this.cap.ifPresent(s -> s.setCount(count));
    }

    public int getExtractSize() {
        return this.cap.isPresent() ? this.cap.get().getExtractSize() : 0;
    }

    public void setExtractSize(int size) {
        this.cap.ifPresent(e -> e.setExtractSize(size));
    }

    public void setRemainingDurability(int size) {
        this.cap.ifPresent(r -> r.setRemainingDurability(size));
    }

    public void setTagCompound(NBTTagCompound tag) {
        this.cap.ifPresent(t -> t.setTagCompound(tag));
    }

    public void add(long count) {
        long current = this.getFileSize();
        this.setFileSize(current + count);
    }

    public void remove(long count) {
        long current = this.getFileSize();
        this.setFileSize(Math.max(current - count, 0L));
    }

    public int getDamageSize() {
        return this.cap.isPresent() ? this.cap.get().getRemainingDurability() : 0;
    }

    public void setDamageSize(int damage) {
        this.cap.ifPresent(d -> d.setRemainingDurability(damage));
    }

    public String getDisplayName() {
        return this.cap.isPresent() ? this.cap.get().getDisplayName() : "";
    }

    public Object getObject() {
        return this.cap.isPresent() ? this.cap.get().getContents() : null;
    }

    public boolean setObject(Object obj) {
        return this.cap.isPresent() ? this.cap.get().setContents(obj) : false;
    }

    public Object insert(Object objects, boolean simulate) {
        return this.insert(objects, simulate, false);
    }

    public Object insert(Object objects, boolean simulate, boolean oreDict) {
        return this.cap.isPresent() ? this.cap.get().insert(objects, simulate, oreDict) : objects;
    }

    public Object extract(long amount, boolean simulate, boolean creative) {
        return this.cap.isPresent() ? this.cap.get().extract(amount, simulate, creative) : null;
    }

    public static boolean areContentsEqual(ItemStack folder1, ItemStack folder2) {
        CapabilityFolder cap1 = FolderUtils.get(folder1).getCap();
        CapabilityFolder cap2 = FolderUtils.get(folder2).getCap();
        if (cap1 == null || cap2 == null) {
            return false;
        }
        if (cap1.isItemStack() && cap2.isItemStack()) {
            if (folder1.func_77952_i() == FolderType.NBT.ordinal()) {
                return ItemStack.func_77970_a((ItemStack)cap1.getItemStack(), (ItemStack)cap2.getItemStack());
            }
            return ItemStack.func_179545_c((ItemStack)cap1.getItemStack(), (ItemStack)cap2.getItemStack());
        }
        if (cap1.isFluidStack() && cap2.isFluidStack()) {
            return FluidStack.areFluidStackTagsEqual((FluidStack)cap1.getFluidStack(), (FluidStack)cap2.getFluidStack());
        }
        if (cap1.isEntity() && cap2.isEntity()) {
            return cap1.getEntityClass().equals(cap2.getEntityClass());
        }
        return false;
    }

    public static boolean allowableIngredient(ItemStack stack) {
        return !(stack.func_77973_b() instanceof IEmptyFolder) && !(stack.func_77973_b() instanceof IFolder) && !(Block.func_149634_a((Item)stack.func_77973_b()) instanceof IBlockCabinet) && stack.func_77973_b() != RFCItems.WHITEOUTTAPE || stack.func_77973_b() == RFCItems.MAGNIFYINGGLASS;
    }
}

