/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.network;

import io.netty.buffer.ByteBuf;
import nc.multiblock.network.MultiblockUpdatePacket;
import nc.multiblock.turbine.Turbine;
import nc.multiblock.turbine.tile.TileTurbineController;
import net.minecraft.util.math.BlockPos;

public class TurbineRenderPacket
extends MultiblockUpdatePacket {
    public float angVel;
    public boolean isProcessing;
    public int recipeRate;

    public TurbineRenderPacket() {
        this.messageValid = false;
    }

    public TurbineRenderPacket(BlockPos pos, float angVel, boolean isProcessing, int recipeRate) {
        this.pos = pos;
        this.angVel = angVel;
        this.isProcessing = isProcessing;
        this.recipeRate = recipeRate;
        this.messageValid = true;
    }

    @Override
    public void readMessage(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.angVel = buf.readFloat();
        this.isProcessing = buf.readBoolean();
        this.recipeRate = buf.readInt();
    }

    @Override
    public void writeMessage(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeFloat(this.angVel);
        buf.writeBoolean(this.isProcessing);
        buf.writeInt(this.recipeRate);
    }

    public static class Handler
    extends MultiblockUpdatePacket.Handler<TurbineRenderPacket, Turbine, TileTurbineController> {
        public Handler() {
            super(TileTurbineController.class);
        }

        @Override
        protected void onPacket(TurbineRenderPacket message, Turbine multiblock) {
            multiblock.onRenderPacket(message);
        }
    }
}

