/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.HashMap;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasHandler;
import nc.util.StringHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GasHelper {
    public static final Map<String, String> TRANSLATION_MAP = new HashMap<String, String>();
    public static final Map<String, String> GAS_MAP = new HashMap<String, String>();
    @CapabilityInject(value=IGasHandler.class)
    public static Capability<IGasHandler> GAS_HANDLER_CAPABILITY = null;

    public static void preInit() {
        TRANSLATION_MAP.put("sulfur_dioxide", "liquidsulfurdioxide");
        TRANSLATION_MAP.put("sulfur_trioxide", "liquidsulfurtrioxide");
        TRANSLATION_MAP.put("hydrogen_chloride", "liquidhydrogenchloride");
        TRANSLATION_MAP.put("sulfuric_acid", "sulfuricacid");
    }

    public static void init() {
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            if (gas.getFluid() == null) continue;
            GAS_MAP.put(gas.getFluid().getName(), gas.getName());
        }
    }

    public static FluidStack getFluidFromGas(GasStack gasStack) {
        if (gasStack == null || gasStack.getGas().getFluid() == null) {
            return null;
        }
        Fluid gasFluid = gasStack.getGas().getFluid();
        if (gasFluid == null) {
            return null;
        }
        Fluid fluid = FluidRegistry.getFluid((String)gasFluid.getName());
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, gasStack.amount);
    }

    public static GasStack getGasFromFluid(FluidStack fluidStack) {
        String gasName;
        if (fluidStack == null) {
            return null;
        }
        String fluidName = fluidStack.getFluid().getName();
        if (!StringHelper.beginsWith("liquid", fluidName)) {
            fluidName = TRANSLATION_MAP.containsKey(fluidName) ? TRANSLATION_MAP.get(fluidName) : "liquid" + fluidName;
        }
        if ((gasName = GAS_MAP.get(fluidName)) == null) {
            return null;
        }
        Gas gas = GasRegistry.getGas((String)gasName);
        if (gas == null) {
            return null;
        }
        return new GasStack(gas, fluidStack.amount);
    }
}

