/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.common.crafting;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import tschipp.primitivecrafting.common.crafting.IPrimitiveRecipe;
import tschipp.primitivecrafting.common.crafting.PrimitiveIngredient;

public class PrimitiveRecipe
implements IPrimitiveRecipe {
    private ItemStack result;
    private PrimitiveIngredient a;
    private PrimitiveIngredient b;
    private String tier = "";
    private ResourceLocation registryName;

    public PrimitiveRecipe(ItemStack result, PrimitiveIngredient a, PrimitiveIngredient b, ResourceLocation loc) {
        this.result = result.func_77946_l();
        this.a = a;
        this.b = b;
        this.registryName = loc;
    }

    @Override
    public ItemStack getResult() {
        return this.result.func_77946_l();
    }

    @Override
    public PrimitiveIngredient getA() {
        return this.a;
    }

    @Override
    public PrimitiveIngredient getB() {
        return this.b;
    }

    @Override
    public boolean isValid(ItemStack a, ItemStack b) {
        boolean bool = this.a.test(a) && this.b.test(b) && this.a.count <= a.func_190916_E() && this.b.count <= b.func_190916_E() || this.a.test(b) && this.b.test(a) && this.a.count <= b.func_190916_E() && this.b.count <= a.func_190916_E();
        return bool;
    }

    @Override
    public void craft(ItemStack a, ItemStack b, @Nullable EntityPlayer player, ItemStack hoverStack, int slot) {
        ItemStack newA = this.sort(a, b, true);
        ItemStack newB = this.sort(a, b, false);
        if (newA != null && newB != null && !newA.func_190926_b() && !newB.func_190926_b()) {
            this.getCraftingResult(newA, newB, player, PrimitiveRecipe.areStacksEqual(newA, hoverStack), slot);
            PrimitiveRecipe.addItem(player, this.getResult());
        }
    }

    @Override
    public void getCraftingResult(ItemStack a, ItemStack b, @Nullable EntityPlayer player, boolean isAHoverStack, int slot) {
        this.getA().getTransformForStack(a).transformStack(a, player, isAHoverStack, slot);
        this.getB().getTransformForStack(b).transformStack(b, player, !isAHoverStack, slot);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.a == null ? 0 : this.a.hashCode());
        result = 31 * result + (this.b == null ? 0 : this.b.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.func_77973_b().hashCode() + this.result.func_77960_j() + (this.result.func_77942_o() ? this.result.func_77978_p().hashCode() : 0));
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof PrimitiveRecipe) {
            PrimitiveRecipe r = (PrimitiveRecipe)other;
            if (r.a.equals(this.a) && r.b.equals(this.b) && PrimitiveRecipe.areStacksEqual(this.result, r.result) && r.registryName.equals((Object)this.registryName)) {
                return true;
            }
        }
        return false;
    }

    public ItemStack sort(ItemStack a, ItemStack b, boolean getA) {
        if (this.getA().test(a) && this.getB().test(b)) {
            if (getA) {
                return a;
            }
            return b;
        }
        if (this.getA().test(b) && this.getB().test(a)) {
            if (getA) {
                return b;
            }
            return a;
        }
        return null;
    }

    public static int compareStacks(ItemStack a, ItemStack b) {
        String bS;
        String aS = a.func_77973_b().getRegistryName().toString();
        int i = aS.compareTo(bS = b.func_77973_b().getRegistryName().toString());
        if (i < 0) {
            return -1;
        }
        if (i > 0) {
            return 1;
        }
        if (a.func_77960_j() < b.func_77960_j()) {
            return -1;
        }
        if (b.func_77960_j() < a.func_77960_j()) {
            return 1;
        }
        if (a.func_77942_o() && !b.func_77942_o()) {
            return 1;
        }
        if (b.func_77942_o() && !a.func_77942_o()) {
            return -1;
        }
        if (a.func_77942_o() && b.func_77942_o()) {
            int k = a.func_77978_p().toString().compareTo(b.func_77978_p().toString());
            if (k < 0) {
                return -1;
            }
            if (k > 0) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static boolean areStacksEqual(ItemStack one, ItemStack other) {
        if (one.func_77973_b() != other.func_77973_b()) {
            return false;
        }
        if (one.func_77960_j() != other.func_77960_j()) {
            return false;
        }
        return one.func_77978_p() == other.func_77978_p();
    }

    public static void addItem(EntityPlayer player, ItemStack stack) {
        if (player != null && !player.field_70170_p.field_72995_K && !player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
    }

    @Override
    public String getTier() {
        return this.tier;
    }

    @Override
    public void setTier(String s) {
        this.tier = s;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }
}

