/*
 * Decompiled with CFR 0.152.
 */
package tschipp.primitivecrafting.compat.jei.crafting;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import tschipp.primitivecrafting.common.crafting.IPrimitiveRecipe;
import tschipp.primitivecrafting.common.crafting.RecipeRegistry;
import tschipp.primitivecrafting.compat.jei.crafting.PrimitiveCraftingWrapper;

public class PrimitiveCraftingCategory
implements IRecipeCategory<PrimitiveCraftingWrapper> {
    public IGuiHelper helper;

    public PrimitiveCraftingCategory(IGuiHelper h) {
        this.helper = h;
    }

    public String getUid() {
        return "primitive_crafting";
    }

    public String getTitle() {
        return I18n.func_74838_a((String)"primitivecrafting.title");
    }

    public String getModName() {
        return "Primitive Crafting";
    }

    public IDrawable getBackground() {
        return this.helper.createBlankDrawable(80, 19);
    }

    public void setRecipe(IRecipeLayout recipeLayout, PrimitiveCraftingWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        IGuiItemStackGroup guiStacks = recipeLayout.getItemStacks();
        guiStacks.init(0, true, 0, 0);
        guiStacks.init(1, true, 30, 0);
        guiStacks.init(2, false, 60, 0);
        guiStacks.set(0, (List)inputs.get(0));
        guiStacks.set(1, (List)inputs.get(1));
        guiStacks.set(2, (List)outputs.get(0));
    }

    public static List<PrimitiveCraftingWrapper> getRecipes() {
        List<IPrimitiveRecipe> recipes = RecipeRegistry.getRecipes();
        ArrayList<PrimitiveCraftingWrapper> wrappers = new ArrayList<PrimitiveCraftingWrapper>();
        recipes.sort((r1, r2) -> r1.getResult().func_77973_b().getRegistryName().toString().compareTo(r2.getResult().func_77973_b().getRegistryName().toString()));
        for (IPrimitiveRecipe r : recipes) {
            wrappers.add(new PrimitiveCraftingWrapper(r));
        }
        return wrappers;
    }

    public IDrawable getIcon() {
        return this.helper.createDrawable(new ResourceLocation("primitivecrafting:textures/gui/icon.png"), 0, 0, 16, 16, 16, 16);
    }
}

