/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.DimensionData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.ChangeDimensionTrigger;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/changed_dimension", classExplaination="These are the functions which can be called on a minecraft:changed_dimension criteria trigger.")
public class ChangedDimensionTriggerData
extends CriterionTriggerData {
    private final DimensionData originData = new DimensionData();
    private final DimensionData destinationData = new DimensionData();

    public ChangedDimensionTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() {
        return new Criterion((ICriterionInstance)new ChangeDimensionTrigger.Instance(this.originData.buildDimensionType(), this.destinationData.buildDimensionType()));
    }

    @ScriptMethodDocumentation(args="String", usage="dimension type", notes="Sets the origin dimension type. Vanilla options are \"overworld\", \"the_nether\", \"the_end\"")
    public void setDimensionOrigin(String type) {
        this.originData.setDimensionType(type);
    }

    @ScriptMethodDocumentation(args="String", usage="dimension type", notes="Sets the destination dimension type. Vanilla options are \"overworld\", \"the_nether\", \"the_end\"")
    public void setDimensionDestination(String type) {
        this.destinationData.setDimensionType(type);
    }
}

