/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data.triumph;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.advancements.criterion.trigger.PlayerDeathTrigger;
import com.bloodnbonesgaming.triumph.config.data.DamageSourceData;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/triumph/player_death", classExplaination="These are the functions which can be called on a triumph:player_death trigger.")
public class PlayerDeathTriggerData
extends CriterionTriggerData {
    private final DamageSourceData damageSourceData = new DamageSourceData();

    public PlayerDeathTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        return new Criterion((ICriterionInstance)new PlayerDeathTrigger.Instance(this.damageSourceData.buildPredicate()));
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the immediate source entity (This would be for things like projectiles.) so functions can be called on it.")
    public EntityData getImmediateSourceData() {
        return this.damageSourceData.getImmediateSourceData();
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object for the source entity (This would be for the player/skeleton/etc.) so functions can be called on it.")
    public EntityData getSourceData() {
        return this.damageSourceData.getSourceData();
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is a projectile.")
    public void isProjectile(boolean bool) {
        this.damageSourceData.isProjectile(bool);
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is an explosion.")
    public void isExplosion(boolean bool) {
        this.damageSourceData.isExplosion(bool);
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source bypasses armor.")
    public void bypassesArmor(boolean bool) {
        this.damageSourceData.bypassesArmor(bool);
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source bypasses invulerability.")
    public void bypassesInvulnerability(boolean bool) {
        this.damageSourceData.bypassesInvulnerability(bool);
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source bypasses magic.")
    public void bypassesMagic(boolean bool) {
        this.damageSourceData.bypassesMagic(bool);
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is fire.")
    public void isFire(boolean bool) {
        this.damageSourceData.isFire(bool);
    }

    @ScriptMethodDocumentation(args="boolean", usage="true/false", notes="Sets if the damage source is magic.")
    public void isMagic(boolean bool) {
        this.damageSourceData.isMagic(bool);
    }

    @ScriptMethodDocumentation(args="String", usage="damage type", notes="Sets the damage type string used to construct the DamageSource. Vanilla examples include \"inFire\", \"outOfWorld\", \"cactus\", \"drown\", \"starve\", etc.")
    public void damageType(String type) {
        this.damageSourceData.damageType(type);
    }
}

