/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage;

import com.tattyseal.compactstorage.ConfigurationHandler;
import com.tattyseal.compactstorage.GuiHandler;
import com.tattyseal.compactstorage.block.BlockBarrel;
import com.tattyseal.compactstorage.block.BlockChest;
import com.tattyseal.compactstorage.block.BlockChestBuilder;
import com.tattyseal.compactstorage.block.BlockFluidBarrel;
import com.tattyseal.compactstorage.client.render.TileEntityBarrelFluidRenderer;
import com.tattyseal.compactstorage.client.render.TileEntityBarrelRenderer;
import com.tattyseal.compactstorage.client.render.TileEntityChestRenderer;
import com.tattyseal.compactstorage.creativetabs.CreativeTabCompactStorage;
import com.tattyseal.compactstorage.event.CompactStorageEventHandler;
import com.tattyseal.compactstorage.event.ConnectionHandler;
import com.tattyseal.compactstorage.item.ItemBackpack;
import com.tattyseal.compactstorage.item.ItemBlockChest;
import com.tattyseal.compactstorage.network.handler.C01HandlerUpdateBuilder;
import com.tattyseal.compactstorage.network.handler.C02HandlerCraftChest;
import com.tattyseal.compactstorage.network.packet.C01PacketUpdateBuilder;
import com.tattyseal.compactstorage.network.packet.C02PacketCraftChest;
import com.tattyseal.compactstorage.proxy.IProxy;
import com.tattyseal.compactstorage.tileentity.TileEntityBarrel;
import com.tattyseal.compactstorage.tileentity.TileEntityBarrelFluid;
import com.tattyseal.compactstorage.tileentity.TileEntityChest;
import com.tattyseal.compactstorage.tileentity.TileEntityChestBuilder;
import com.tattyseal.compactstorage.util.ModelUtil;
import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="compactstorage", name="CompactStorage", version="3.1", guiFactory="com.tattyseal.compactstorage.client.gui.factory.CompactStorageGuiFactory", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class CompactStorage {
    @Mod.Instance(value="compactstorage")
    public static CompactStorage instance;
    @SidedProxy(clientSide="com.tattyseal.compactstorage.proxy.ClientProxy", serverSide="com.tattyseal.compactstorage.proxy.ServerProxy", modId="compactstorage")
    public static IProxy proxy;
    public static final CreativeTabs tabCS;
    public static final Logger logger;
    public SimpleNetworkWrapper wrapper;
    public static final String ID = "compactstorage";

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{ModBlocks.chest = new BlockChest(), ModBlocks.chestBuilder = new BlockChestBuilder(), ModBlocks.barrel = new BlockBarrel(), ModBlocks.barrel_fluid = new BlockFluidBarrel()});
        GameRegistry.registerTileEntity(TileEntityChest.class, (String)"tileChest");
        GameRegistry.registerTileEntity(TileEntityChestBuilder.class, (String)"tileChestBuilder");
        GameRegistry.registerTileEntity(TileEntityBarrel.class, (String)"tileBarrel");
        GameRegistry.registerTileEntity(TileEntityBarrelFluid.class, (String)"tileBarrel_fluid");
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        ModItems.ibChest = new ItemBlockChest(ModBlocks.chest);
        ModItems.ibChest.setRegistryName("compactChest");
        e.getRegistry().register((IForgeRegistryEntry)ModItems.ibChest);
        ItemBlock ibChestBuilder = new ItemBlock(ModBlocks.chestBuilder);
        ibChestBuilder.setRegistryName("chestBuilder");
        ibChestBuilder.func_77637_a(tabCS);
        e.getRegistry().register((IForgeRegistryEntry)ibChestBuilder);
        ModItems.backpack = new ItemBackpack();
        ModItems.backpack.setRegistryName("backpack");
        e.getRegistry().register((IForgeRegistryEntry)ModItems.backpack);
        ModItems.itemBlockBarrel = new ItemBlock(ModBlocks.barrel);
        ModItems.itemBlockBarrel.setRegistryName(ModBlocks.barrel.getRegistryName());
        e.getRegistry().register((IForgeRegistryEntry)ModItems.itemBlockBarrel);
        ModItems.itemBlockBarrel_fluid = new ItemBlock(ModBlocks.barrel_fluid);
        ModItems.itemBlockBarrel_fluid.setRegistryName(ModBlocks.barrel_fluid.getRegistryName());
        e.getRegistry().register((IForgeRegistryEntry)ModItems.itemBlockBarrel_fluid);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityChest.class, (TileEntitySpecialRenderer)new TileEntityChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBarrel.class, (TileEntitySpecialRenderer)new TileEntityBarrelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBarrelFluid.class, (TileEntitySpecialRenderer)new TileEntityBarrelFluidRenderer());
        ModelUtil.registerChest();
        ModelUtil.registerBlock(ModBlocks.chestBuilder, 0, "compactstorage:chestBuilder");
        ModelUtil.registerItem((Item)ModItems.itemBlockBarrel, 0, "compactstorage:barrel");
        ModelUtil.registerItem((Item)ModItems.itemBlockBarrel_fluid, 0, "compactstorage:barrel_fluid");
        ModelUtil.registerBlock(ModBlocks.chest, 0, "compactstorage:compactchest");
        ModelUtil.registerItem(ModItems.backpack, 0, "compactstorage:backpack");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        OreDictionary.registerOre((String)"barsIron", (Block)Blocks.field_150411_aY);
        OreDictionary.registerOre((String)"blockChest", (Block)Blocks.field_150486_ae);
        OreDictionary.registerOre((String)"itemClay", (Item)Items.field_151119_aD);
        OreDictionary.registerOre((String)"string", (Item)Items.field_151007_F);
        OreDictionary.registerOre((String)"wool", (Block)Blocks.field_150325_L);
        this.wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(ID);
        this.wrapper.registerMessage(C01HandlerUpdateBuilder.class, C01PacketUpdateBuilder.class, 0, Side.SERVER);
        this.wrapper.registerMessage(C02HandlerCraftChest.class, C02PacketCraftChest.class, 1, Side.SERVER);
        ConfigurationHandler.configFile = event.getSuggestedConfigurationFile();
        MinecraftForge.EVENT_BUS.register((Object)new ConnectionHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompactStorageEventHandler());
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(ID, "chest_builder"), null, (ItemStack)new ItemStack(ModBlocks.chestBuilder, 1), (Object[])new Object[]{"ILI", "ICI", "ILI", Character.valueOf('I'), new ItemStack(Items.field_151042_j, 1), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae, 1), Character.valueOf('L'), new ItemStack(Blocks.field_150442_at, 1)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(ID, "barrel"), null, (ItemStack)new ItemStack(ModBlocks.barrel, 1), (Object[])new Object[]{"III", "GCG", "III", Character.valueOf('I'), new ItemStack(Items.field_151042_j, 1), Character.valueOf('G'), new ItemStack(Blocks.field_150339_S, 1), Character.valueOf('C'), new ItemStack((Block)Blocks.field_150486_ae, 1)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(ID, "drum"), null, (ItemStack)new ItemStack(ModBlocks.barrel_fluid, 1), (Object[])new Object[]{"ICI", "GIG", "ICI", Character.valueOf('I'), new ItemStack(Items.field_151042_j, 1), Character.valueOf('G'), new ItemStack(Blocks.field_150339_S, 1), Character.valueOf('C'), new ItemStack(Blocks.field_150410_aZ, 1)});
        ConfigurationHandler.init();
    }

    public static int getColorFromHue(int hue) {
        Color color = hue == -1 ? Color.white : Color.getHSBColor((float)hue / 360.0f, 0.5f, 0.5f).brighter();
        return color.getRGB();
    }

    public static int getColorFromNBT(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("hue")) {
            int hue = stack.func_77978_p().func_74762_e("hue");
            return CompactStorage.getColorFromHue(hue);
        }
        if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("hue") && stack.func_77978_p().func_74764_b("color")) {
            String color = "";
            if (tag.func_74781_a("color") instanceof NBTTagInt) {
                color = String.format("#%06X", 0xFFFFFF & tag.func_74762_e("color"));
            } else {
                color = tag.func_74779_i("color");
                if (color.startsWith("0x")) {
                    color = "#" + color.substring(2);
                }
            }
            if (!color.isEmpty()) {
                Color c = Color.decode(color);
                float[] hsbVals = new float[3];
                hsbVals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsbVals);
                tag.func_74768_a("hue", (int)(hsbVals[0] * 360.0f));
            }
        }
        return 0xFFFFFF;
    }

    static {
        tabCS = new CreativeTabCompactStorage();
        logger = LogManager.getLogger((String)"CompactStorage");
    }

    @GameRegistry.ObjectHolder(value="compactstorage")
    public static class ModItems {
        public static ItemBlock itemBlockBarrel;
        public static ItemBlock itemBlockBarrel_fluid;
        public static ItemBlockChest ibChest;
        public static Item backpack;
    }

    @GameRegistry.ObjectHolder(value="compactstorage")
    public static class ModBlocks {
        public static Block chest;
        public static Block chestBuilder;
        public static Block barrel;
        public static Block barrel_fluid;
    }
}

