/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.client.render;

import com.tattyseal.compactstorage.tileentity.TileEntityBarrelFluid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class TileEntityBarrelFluidRenderer
extends TileEntitySpecialRenderer<TileEntityBarrelFluid> {
    public static final ResourceLocation blockSheet = new ResourceLocation("textures/atlas/blocks.png");

    public void render(TileEntityBarrelFluid te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)te, x, y, z, partialTicks, destroyStage, alpha);
        FluidStack stack = te.tank.getFluid();
        if (stack != null) {
            TextureAtlasSprite tex = Minecraft.func_71410_x().func_147117_R().func_110572_b(stack.getFluid().getStill().toString());
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder builder = tessellator.func_178180_c();
            this.func_147499_a(blockSheet);
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glDisable((int)2896);
            float increments = 0.0625f;
            float minXZ = increments * 3.0f;
            float maxXZ = increments * 13.0f;
            float baseHeight = increments;
            float height = increments * 14.0f / (float)te.tank.getCapacity() * (float)te.tank.getFluidAmount() + baseHeight;
            double minU = tex.func_94214_a(3.0);
            double maxU = tex.func_94214_a(13.0);
            double minV = tex.func_94207_b(3.0);
            double maxV = tex.func_94207_b(13.0);
            double minV_side = tex.func_94207_b(0.0);
            double maxV_side = tex.func_94207_b((double)((te.tank.getFluidAmount() - 0) * 16 / (te.tank.getCapacity() - 0) + 0));
            builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            builder.func_181662_b((double)maxXZ, (double)height, (double)maxXZ).func_187315_a(maxU, maxV).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)height, (double)minXZ).func_187315_a(maxU, minV).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)height, (double)minXZ).func_187315_a(minU, minV).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)height, (double)maxXZ).func_187315_a(minU, maxV).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)baseHeight, (double)maxXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)height, (double)maxXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)height, (double)minXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)baseHeight, (double)minXZ).func_187315_a(minU, maxV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)baseHeight, (double)minXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)height, (double)minXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)height, (double)maxXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)baseHeight, (double)maxXZ).func_187315_a(minU, maxV_side).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)baseHeight, (double)minXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)height, (double)minXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)height, (double)minXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)baseHeight, (double)minXZ).func_187315_a(minU, maxV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)baseHeight, (double)maxXZ).func_187315_a(maxU, maxV_side).func_181675_d();
            builder.func_181662_b((double)maxXZ, (double)height, (double)maxXZ).func_187315_a(maxU, minV_side).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)height, (double)maxXZ).func_187315_a(minU, minV_side).func_181675_d();
            builder.func_181662_b((double)minXZ, (double)baseHeight, (double)maxXZ).func_187315_a(minU, maxV_side).func_181675_d();
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            float scale = 0.01f;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            float angle = Minecraft.func_71410_x().field_71439_g.field_70177_z;
            GL11.glTranslatef((float)0.0f, (float)0.5001f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            FontRenderer fontrenderer = this.func_147498_b();
            int b0 = 0;
            String s = te.getText();
            fontrenderer.func_78276_b(s, -fontrenderer.func_78256_a(s) / 2, -5, b0);
            GL11.glPopMatrix();
        }
    }
}

