/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.inventory;

import com.tattyseal.compactstorage.api.IChest;
import com.tattyseal.compactstorage.util.StorageInfo;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;

public class InventoryBackpack
implements IChest {
    public ItemStack stack;
    public int[] size;
    public ItemStack[] items;
    public StorageInfo info;
    private String customName;

    public InventoryBackpack(ItemStack stack) {
        this.stack = stack;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("size")) {
            this.size = stack.func_77978_p().func_74759_k("size");
            this.info = new StorageInfo(this.size[0], this.size[1], stack.func_77978_p().func_74762_e("hue"), StorageInfo.Type.BACKPACK);
        } else {
            this.size = new int[]{9, 3};
            this.info = new StorageInfo(this.size[0], this.size[1], 180, StorageInfo.Type.BACKPACK);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74783_a("size", new int[]{9, 3});
        }
        this.items = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = ItemStack.field_190927_a;
        }
        this.readFromNBT(this.stack.func_77978_p());
        if (stack.func_82837_s()) {
            this.setCustomName(stack.func_82833_r());
        }
    }

    @Override
    public int getInvX() {
        return this.size[0];
    }

    @Override
    public int getInvY() {
        return this.size[1];
    }

    @Override
    public StorageInfo getInfo() {
        return this.info;
    }

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    public int func_70302_i_() {
        return this.getInvX() * this.getInvY() + 1;
    }

    public boolean func_191420_l() {
        return false;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot < this.items.length && this.items[slot] != null && this.items[slot] != ItemStack.field_190927_a) {
            return this.items[slot];
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.func_70296_d();
                return stack.func_77946_l();
            }
            ItemStack stack2 = stack.func_77979_a(amount);
            this.func_70296_d();
            return stack2.func_77946_l();
        }
        return stack;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.items[slot] = stack;
        this.func_70296_d();
    }

    @Nonnull
    public String func_70005_c_() {
        return "backpack.inv";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        this.writeToNBT(this.stack.func_77978_p());
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return false;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
        this.writeToNBT(this.stack.func_77978_p());
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    private void readFromNBT(NBTTagCompound tag) {
        NBTTagList nbtTagList = tag.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int slot = 0; slot < nbtTagList.func_74745_c(); ++slot) {
            NBTTagCompound item = nbtTagList.func_150305_b(slot);
            int i = item.func_74762_e("Slot");
            if (i < 0 || i >= this.func_70302_i_()) continue;
            this.items[i] = new ItemStack(item);
        }
        if (this.stack.func_77942_o() && !this.stack.func_77978_p().func_74764_b("hue") && this.stack.func_77978_p().func_74764_b("color")) {
            String color;
            if (tag.func_74781_a("color") instanceof NBTTagInt) {
                color = String.format("#%06X", 0xFFFFFF & tag.func_74762_e("color"));
            } else {
                color = tag.func_74779_i("color");
                if (color.startsWith("0x")) {
                    color = "#" + color.substring(2);
                }
            }
            if (!color.isEmpty()) {
                Color c = Color.decode(color);
                float[] hsbVals = new float[3];
                hsbVals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsbVals);
                tag.func_74768_a("hue", (int)(hsbVals[0] * 360.0f));
                tag.func_82580_o("color");
            }
        }
    }

    private void writeToNBT(NBTTagCompound tag) {
        NBTTagList nbtTagList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (slot >= this.items.length || this.items[slot] == null || this.items[slot] == ItemStack.field_190927_a) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", slot);
            this.items[slot].func_77955_b(item);
            nbtTagList.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)nbtTagList);
        tag.func_74768_a("hue", this.getHue());
    }

    @Override
    public boolean shouldConnectToNetwork() {
        return false;
    }

    @Override
    public boolean getRetaining() {
        return true;
    }

    @Override
    public void setRetaining(boolean retaining) {
    }

    @Override
    public int getHue() {
        return this.info.getHue();
    }

    @Override
    public void setHue(int hue) {
        this.info.setHue(hue);
    }
}

