/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.tileentity;

import com.tattyseal.compactstorage.tileentity.IBarrel;
import com.tattyseal.compactstorage.util.LogHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileEntityBarrel
extends TileEntity
implements IBarrel {
    public ItemStack item = ItemStack.field_190927_a;
    public int stackSize = 0;
    public int hue = 128;

    @Override
    public ItemStack dropItems(EntityPlayer player) {
        ItemStack stack = this.dropItems(player, this.item.func_190926_b() ? 64 : this.item.func_77976_d(), false);
        return stack;
    }

    public ItemStack dropItems(EntityPlayer player, int amount, boolean simulate) {
        if (this.stackSize > 0) {
            ItemStack stack = this.item.func_77946_l();
            if (this.stackSize > amount) {
                LogHelper.dump("stack size was > maxStackSize");
                stack.func_190920_e(amount);
                if (!simulate) {
                    this.stackSize -= amount;
                }
            } else {
                LogHelper.dump("stack size was < maxStackSize, stacksize was " + this.stackSize);
                stack.func_190920_e(this.stackSize);
                if (!simulate) {
                    this.stackSize = 0;
                    this.item = ItemStack.field_190927_a;
                }
            }
            this.func_70296_d();
            return stack;
        }
        LogHelper.dump("No items inside!");
        this.func_70296_d();
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack insertItems(@Nonnull ItemStack stack, EntityPlayer player) {
        return this.insertItems(stack, player, false);
    }

    public ItemStack insertItems(@Nonnull ItemStack stack, EntityPlayer player, boolean simulate) {
        ItemStack workingStack = stack.func_77946_l();
        LogHelper.dump("starting method");
        if (this.item.func_190926_b() && !workingStack.func_190926_b()) {
            LogHelper.dump("item was empty, setting item to stack, stack size was " + this.item.func_190916_E());
            if (!simulate) {
                this.item = workingStack.func_77946_l();
                this.stackSize = this.item.func_190916_E();
            }
            workingStack.func_190920_e(0);
            this.func_70296_d();
            return workingStack;
        }
        if (!workingStack.func_190926_b() && ItemStack.func_179545_c((ItemStack)workingStack, (ItemStack)this.item) && this.stackSize < this.getMaxStorage()) {
            LogHelper.dump("stack was not null, the items were equal and storage was less than max");
            if (!simulate) {
                this.stackSize += workingStack.func_190916_E();
            }
            workingStack.func_190920_e(0);
            this.func_70296_d();
            return workingStack;
        }
        LogHelper.dump(String.format("error inserting, stack was empty = %b, items are equal = %b, stackSize was less than %d = %b", stack.func_190926_b(), ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.item), this.getMaxStorage(), this.stackSize < this.getMaxStorage()));
        this.func_70296_d();
        return workingStack;
    }

    @Override
    public int color() {
        return this.hue;
    }

    public String getText() {
        if (this.item.func_190926_b()) {
            return "Empty";
        }
        if (this.stackSize < this.item.func_77976_d()) {
            return this.stackSize + "";
        }
        int numOfStacks = this.stackSize / this.item.func_77976_d();
        return numOfStacks + "x" + this.item.func_77976_d();
    }

    public int getMaxStorage() {
        if (this.item == ItemStack.field_190927_a) {
            return 4096;
        }
        return this.item.func_77976_d() * 64;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("item", (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
        compound.func_74768_a("stackSize", this.stackSize);
        compound.func_74768_a("hue", this.hue);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.item = new ItemStack(compound.func_74775_l("item"));
        this.stackSize = compound.func_74762_e("stackSize");
        this.hue = compound.func_74762_e("hue");
        super.func_145839_a(compound);
        this.func_70296_d();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.func_189515_b(tag);
        return tag;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public IBlockState getState() {
        return this.field_145850_b.func_180495_p(this.field_174879_c);
    }

    public void func_70296_d() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.getState(), this.getState(), 3);
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), 0, 0);
        }
        super.func_70296_d();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new IItemHandler(){

                public int getSlots() {
                    return 1;
                }

                @Nonnull
                public ItemStack getStackInSlot(int slot) {
                    ItemStack s = TileEntityBarrel.this.item.func_77946_l();
                    s.func_190920_e(TileEntityBarrel.this.stackSize);
                    return s;
                }

                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    return TileEntityBarrel.this.insertItems(stack, null, simulate);
                }

                @Nonnull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    return TileEntityBarrel.this.dropItems(null, amount, simulate);
                }

                public int getSlotLimit(int slot) {
                    return TileEntityBarrel.this.getMaxStorage();
                }
            });
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return super.hasCapability(capability, facing) || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }
}

