/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.tileentity;

import com.tattyseal.compactstorage.util.StorageInfo;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileEntityChestBuilder
extends TileEntity
implements IInventory,
ITickable {
    public StorageInfo info = new StorageInfo(9, 3, 180, StorageInfo.Type.CHEST);
    public int dimension;
    public boolean init = false;
    public ItemStack[] items = new ItemStack[this.func_70302_i_()];
    private String customName;
    public int mode;
    public String player;

    public TileEntityChestBuilder() {
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = ItemStack.field_190927_a;
        }
    }

    @Nonnull
    public NBTTagCompound getTileData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    @Nonnull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag = this.func_189515_b(tag);
        return tag;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("infoX", this.info.getSizeX());
        tag.func_74768_a("infoY", this.info.getSizeY());
        tag.func_74768_a("infoHue", this.info.getHue());
        tag.func_74768_a("type", this.info.getType().ordinal());
        NBTTagList nbtTagList = new NBTTagList();
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (this.items == null || this.items[slot] == null || this.items[slot] == ItemStack.field_190927_a) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", slot);
            this.items[slot].func_77955_b(item);
            nbtTagList.func_74742_a((NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)nbtTagList);
        if (this.func_145818_k_()) {
            tag.func_74778_a("Name", this.customName);
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.info = new StorageInfo(tag.func_74762_e("infoX"), tag.func_74762_e("infoY"), tag.func_74762_e("hue"), StorageInfo.Type.values()[tag.func_74762_e("type")]);
        this.mode = tag.func_74762_e("mode");
        this.player = tag.func_74779_i("player");
        NBTTagList nbtTagList = tag.func_150295_c("Items", 10);
        this.items = new ItemStack[this.func_70302_i_()];
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            NBTTagCompound item = nbtTagList.func_150305_b(slot);
            this.items[slot] = new ItemStack(item);
        }
        if (tag.func_150297_b("Name", 8)) {
            this.customName = tag.func_74779_i("Name");
        }
        this.func_70296_d();
    }

    public void func_73660_a() {
        if (!this.init) {
            this.dimension = this.func_145831_w().field_73011_w.getDimension();
            this.init = true;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public int func_70302_i_() {
        return 5;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != ItemStack.field_190927_a) {
            if (stack.func_190916_E() <= amount) {
                this.func_70299_a(slot, ItemStack.field_190927_a);
                this.func_70296_d();
            } else {
                ItemStack stack2 = stack.func_77979_a(amount);
                this.func_70296_d();
                return stack2;
            }
        }
        return stack;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        this.items[index] = ItemStack.field_190927_a;
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        this.items[slot] = stack;
    }

    @Nonnull
    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "chestbuilder.json";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean func_191420_l() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        if (this.info != null) {
            return stack.func_77973_b().equals(this.info.getMaterialCost().get(slot).func_77973_b());
        }
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public boolean canPlayerAccess(String name) {
        switch (this.mode) {
            case 0: {
                return true;
            }
            case 1: {
                return name.equals(this.player);
            }
            case 2: {
                return name.equals(this.player);
            }
        }
        return false;
    }

    public int getAccess() {
        return this.mode;
    }

    public String getOwnerName() {
        return this.player;
    }

    public boolean setAccess(int mode) {
        this.mode = mode;
        return true;
    }

    public boolean setOwnerName(String name) {
        this.player = name;
        return true;
    }
}

