/*
 * Decompiled with CFR 0.152.
 */
package com.tattyseal.compactstorage.util;

import com.tattyseal.compactstorage.CompactStorage;
import com.tattyseal.compactstorage.ConfigurationHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class StorageInfo {
    private int sizeX;
    private int sizeY;
    private int hue;
    private Type type;

    public StorageInfo(int sizeX, int sizeY, int hue, Type type) {
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.hue = hue;
        this.type = type;
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public void setSizeX(int sizeX) {
        this.sizeX = sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    public void setSizeY(int sizeY) {
        this.sizeY = sizeY;
    }

    public int getHue() {
        return this.hue;
    }

    public void setHue(int hue) {
        this.hue = hue;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<ItemStack> getMaterialCost() {
        Type type = this.getType();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int storageAmount = (int)((float)(this.sizeX * this.sizeY) / 8.0f * ConfigurationHandler.storageModifier);
        list.add(this.changeStackSize(type.equals((Object)Type.BACKPACK) ? ConfigurationHandler.storageBackpack : ConfigurationHandler.storage, type.equals((Object)Type.BACKPACK) ? storageAmount : storageAmount / 2));
        int amount = ConfigurationHandler.primary.length;
        int maxChest = 288;
        int thisChest = this.sizeX * this.sizeY;
        int divider = maxChest / amount;
        int primaryTier = 0;
        for (int i = 0; i < amount; ++i) {
            if (thisChest > divider * (i + 1)) continue;
            primaryTier = i;
            break;
        }
        ItemStack primaryStack = ConfigurationHandler.primary[primaryTier];
        list.add(this.changeStackSize(primaryStack, (int)((float)(this.sizeX * this.sizeY) / 4.5f / (float)(primaryTier + 1) * ConfigurationHandler.primaryModifier)));
        amount = ConfigurationHandler.secondary.length;
        divider = maxChest / amount;
        int secondaryTier = 0;
        for (int i = 0; i < amount; ++i) {
            if (thisChest > divider * (i + 1)) continue;
            secondaryTier = i;
            break;
        }
        ItemStack secondaryStack = ConfigurationHandler.secondary[secondaryTier];
        list.add(this.changeStackSize(secondaryStack, (int)((float)(this.sizeX * this.sizeY) / 4.5f / (float)(secondaryTier + 1) * ConfigurationHandler.secondaryModifier)));
        int binderAmount = (int)((float)(this.sizeX * this.sizeY) / 8.0f * ConfigurationHandler.binderModifier);
        list.add(this.changeStackSize(type.equals((Object)Type.BACKPACK) ? ConfigurationHandler.binderBackpack : ConfigurationHandler.binder, binderAmount / 2));
        return list;
    }

    public ItemStack changeStackSize(ItemStack stack, int amount) {
        if (amount <= 0) {
            amount = 1;
        }
        stack.func_190920_e(amount);
        return stack;
    }

    public static enum Type {
        CHEST("Chest", new ItemStack(CompactStorage.ModBlocks.chest, 1)),
        BACKPACK("Backpack", new ItemStack(CompactStorage.ModItems.backpack, 1));

        public String name;
        public ItemStack display;

        private Type(String name, ItemStack display) {
            this.name = name;
            this.display = display;
        }
    }
}

