/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.recipestages.recipes;

import com.blamejared.recipestages.RecipeStages;
import com.blamejared.recipestages.handlers.Recipes;
import java.util.Map;
import net.darkhax.gamestages.GameStageHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeStage
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private String tier;
    private IRecipe recipe;
    private boolean shapeless;
    private int width;
    private int height;

    public RecipeStage(String tier, IRecipe recipe, boolean shapeless) {
        this.tier = tier;
        this.recipe = recipe;
        this.shapeless = shapeless;
    }

    public RecipeStage(String tier, IRecipe recipe, boolean shapeless, int width, int height) {
        this.tier = tier;
        this.recipe = recipe;
        this.shapeless = shapeless;
        this.width = width;
        this.height = height;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.recipe.func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (this.isGoodForCrafting(inv)) {
            return this.recipe.func_77572_b(inv);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return this.recipe.func_194133_a(width, height);
    }

    public boolean isGoodForCrafting(InventoryCrafting inv) {
        PlayerList manager;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            EntityPlayer player = RecipeStages.proxy.getClientPlayer();
            if (player == null || player instanceof FakePlayer) {
                return true;
            }
            return GameStageHelper.getPlayerData((EntityPlayer)player).hasStage(this.tier);
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (manager = server.func_184103_al()) != null) {
            Container container = inv.field_70465_c;
            if (container == null) {
                return false;
            }
            EntityPlayerMP foundPlayer = null;
            for (EntityPlayerMP entityPlayerMP : manager.func_181057_v()) {
                if (entityPlayerMP.field_71070_bA != container || !container.func_75145_c((EntityPlayer)entityPlayerMP) || !container.func_75129_b((EntityPlayer)entityPlayerMP)) continue;
                if (foundPlayer != null) {
                    return false;
                }
                foundPlayer = entityPlayerMP;
            }
            if (foundPlayer != null) {
                return GameStageHelper.getPlayerData(foundPlayer).hasStage(this.tier);
            }
        }
        if (Recipes.printContainers) {
            System.out.println("Current container: " + inv.field_70465_c.getClass().getName());
        }
        if (Recipes.crafterStages.getOrDefault(inv.field_70465_c.getClass().getName(), new String[0]).length > 0) {
            for (String s : Recipes.crafterStages.get(inv.field_70465_c.getClass().getName())) {
                if (!this.tier.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        for (Map.Entry entry : Recipes.packageStages.entrySet()) {
            String pack = ((String)entry.getKey()).toLowerCase();
            String[] stages = (String[])entry.getValue();
            if (!inv.field_70465_c.getClass().getName().toLowerCase().startsWith(pack)) continue;
            for (String s : stages) {
                if (!this.tier.equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return this.recipe.func_179532_b(inv);
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipe.func_192400_c();
    }

    public IRecipe getRecipe() {
        return this.recipe;
    }

    public String getTier() {
        return this.tier;
    }

    public String toString() {
        return "RecipeStage{tier='" + this.tier + '\'' + ", recipe=" + this.recipe.func_77571_b() + ":" + this.recipe.func_192400_c() + '}';
    }

    public boolean isShapeless() {
        return this.shapeless;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

