/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.shell;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.ichun.mods.ichunutil.common.core.network.AbstractPacket;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.core.ChunkLoadHandler;
import me.ichun.mods.sync.common.packet.PacketClearShellList;
import me.ichun.mods.sync.common.packet.PacketShellState;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.logging.log4j.Level;

public class ShellHandler {
    public static SetMultimap<String, TileEntityDualVertical> playerShells = HashMultimap.create();
    public static HashMap<String, TileEntityDualVertical> syncInProgress = new HashMap();

    public static void addShell(String playerName, TileEntityDualVertical dualVertical, boolean shouldChunkLoad) {
        if (!playerShells.containsEntry((Object)playerName, (Object)dualVertical)) {
            playerShells.put((Object)playerName, (Object)dualVertical);
            if (shouldChunkLoad && !ChunkLoadHandler.isAlreadyChunkLoaded(dualVertical)) {
                ChunkLoadHandler.addShellAsChunkloader(dualVertical);
            }
        }
    }

    public static void removeShell(String playerName, TileEntityDualVertical dualVertical) {
        if (playerName != null && dualVertical != null) {
            playerShells.remove((Object)playerName, (Object)dualVertical);
            ChunkLoadHandler.removeShellAsChunkloader(dualVertical);
            dualVertical.reset();
            IBlockState state = dualVertical.func_145831_w().func_180495_p(dualVertical.func_174877_v());
            IBlockState state1 = dualVertical.func_145831_w().func_180495_p(dualVertical.func_174877_v().func_177982_a(0, 1, 0));
            dualVertical.func_145831_w().func_184138_a(dualVertical.func_174877_v(), state, state, 3);
            dualVertical.func_145831_w().func_184138_a(dualVertical.func_174877_v().func_177982_a(0, 1, 0), state1, state1, 3);
        } else {
            Sync.LOGGER.log(Level.WARN, String.format("Attempted to remove a shell but something was null for %s at %s", new Object[]{playerName, dualVertical}));
        }
    }

    public static boolean isShellAlreadyRegistered(TileEntityDualVertical dualVertical) {
        return playerShells.containsValue((Object)dualVertical);
    }

    public static void updatePlayerOfShells(EntityPlayer player, TileEntityDualVertical dv, boolean all) {
        ArrayList<TileEntityDualVertical> dvs = new ArrayList<TileEntityDualVertical>();
        ArrayList<TileEntityDualVertical> remove = new ArrayList<TileEntityDualVertical>();
        if (all) {
            Sync.channel.sendTo((AbstractPacket)new PacketClearShellList(), player);
            for (Map.Entry e : playerShells.entries()) {
                if (!((String)e.getKey()).equalsIgnoreCase(player.func_70005_c_())) continue;
                TileEntityDualVertical dualVertical = (TileEntityDualVertical)((Object)e.getValue());
                if (dualVertical.func_145831_w().func_175625_s(dualVertical.func_174877_v()) == dualVertical) {
                    dvs.add(dualVertical);
                    continue;
                }
                remove.add(dualVertical);
            }
        } else if (dv != null) {
            dvs.add(dv);
        }
        for (TileEntityDualVertical dv1 : dvs) {
            if (dv1.top) continue;
            Sync.channel.sendTo((AbstractPacket)new PacketShellState(dv1, false), player);
        }
        for (TileEntityDualVertical dv1 : remove) {
            ShellHandler.removeShell(dv1.getPlayerName(), dv1);
        }
    }

    public static void updatePlayerOfShellRemoval(EntityPlayer player, TileEntityDualVertical dv) {
        if (dv.top) {
            return;
        }
        Sync.channel.sendTo((AbstractPacket)new PacketShellState(dv, true), player);
    }
}

