/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.tileentity;

import java.util.List;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityShellConstructor
extends TileEntityDualVertical<TileEntityShellConstructor>
implements IEnergyStorage {
    public float constructionProgress = 0.0f;
    public int doorTime = 0;
    public int rfBuffer;
    public boolean doorOpen = false;
    public float prevPower;

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.top && this.pair != null) {
            this.constructionProgress = ((TileEntityShellConstructor)this.pair).constructionProgress;
            this.doorOpen = ((TileEntityShellConstructor)this.pair).doorOpen;
        }
        if (this.isPowered()) {
            float power = this.powerAmount();
            if (this.field_145850_b.func_72820_D() % 200L == 0L && this.prevPower != power) {
                EntityPlayerMP player;
                this.prevPower = power;
                if (!this.top && !this.field_145850_b.field_72995_K && (player = this.getPlayerIfAvailable()) != null) {
                    ShellHandler.updatePlayerOfShells((EntityPlayer)player, null, true);
                }
            }
            this.constructionProgress += power;
            if (this.constructionProgress > (float)Sync.config.shellConstructionPowerRequirement) {
                this.constructionProgress = Sync.config.shellConstructionPowerRequirement;
            }
            if (this.field_145850_b.func_72820_D() % 40L == 0L) {
                this.field_145850_b.func_175685_c(this.func_174877_v(), this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c(), true);
            }
        }
        if (!this.top) {
            if (this.doorOpen) {
                BlockPos pos;
                List list;
                if (this.doorTime < 40) {
                    ++this.doorTime;
                }
                if (!this.field_145850_b.field_72995_K && this.doorTime == 40 && (list = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB((double)(pos = this.func_174877_v()).func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))).isEmpty()) {
                    this.doorOpen = false;
                    IBlockState state = this.field_145850_b.func_180495_p(pos);
                    this.field_145850_b.func_184138_a(pos, state, state, 3);
                }
            } else if (this.doorTime > 0) {
                --this.doorTime;
            }
            if (!(this.field_145850_b.field_72995_K || this.playerName.equalsIgnoreCase("") || ShellHandler.isShellAlreadyRegistered(this))) {
                ShellHandler.addShell(this.playerName, this, true);
            }
        }
        if (!this.top && !this.field_145850_b.field_72995_K) {
            this.rfBuffer += Math.abs(this.powReceived - this.rfIntake);
            if ((float)this.rfBuffer / (float)Sync.config.shellConstructionPowerRequirement > 0.05f || Math.abs((float)(this.powReceived - this.rfIntake) / (float)this.powReceived) > 0.1f) {
                this.rfIntake = this.powReceived;
                this.rfBuffer = 0;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
            this.powReceived = 0;
        }
    }

    public boolean isPowered() {
        if (this.top && this.pair != null) {
            return ((TileEntityShellConstructor)this.pair).isPowered();
        }
        return !this.playerName.equalsIgnoreCase("");
    }

    @Override
    public float getBuildProgress() {
        return this.constructionProgress;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74776_a("constructionProgress", this.constructionProgress);
        tag.func_74757_a("doorOpen", this.doorOpen);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.constructionProgress = tag.func_74760_g("constructionProgress");
        this.doorOpen = tag.func_74767_n("doorOpen");
        this.resync = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.constructionProgress = 0.0f;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && !this.top || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int powReq = Math.max((int)Math.ceil((float)Sync.config.shellConstructionPowerRequirement - this.constructionProgress), 0);
        if (powReq == 0 || this.playerName.equalsIgnoreCase("")) {
            return 0;
        }
        int pow = maxReceive;
        if (pow > 24) {
            pow = 24;
        }
        if (pow > powReq) {
            pow = powReq;
        }
        if (!simulate) {
            this.powReceived = (int)((float)this.powReceived + (float)pow * (float)Sync.config.ratioRF);
        }
        return pow;
    }

    public int extractEnergy(int maxExtract, boolean doExtract) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return (int)Math.ceil((float)Sync.config.shellConstructionPowerRequirement - this.constructionProgress) > 0;
    }
}

