/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.sync.common.tileentity;

import java.util.UUID;
import me.ichun.mods.ichunutil.common.core.util.EntityHelper;
import me.ichun.mods.sync.common.Sync;
import me.ichun.mods.sync.common.shell.ShellHandler;
import me.ichun.mods.sync.common.tileentity.TileEntityDualVertical;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityShellStorage
extends TileEntityDualVertical<TileEntityShellStorage>
implements IEnergyStorage {
    public boolean occupied = false;
    public boolean syncing = false;
    public boolean hasPower = true;
    public EntityPlayer playerInstance = null;
    public String prevPlayerName = "";
    public int occupationTime = 0;

    @Override
    public void func_73660_a() {
        IBlockState state;
        if (this.resync && this.field_145850_b.field_72995_K && !this.playerName.equalsIgnoreCase("") && !this.prevPlayerName.equals(this.playerName) && this.syncing) {
            this.playerInstance = TileEntityShellStorage.createPlayer(this.field_145850_b, this.playerUUID, this.playerName);
            this.prevPlayerName = this.playerName;
            if (this.playerNBT.func_74764_b("Inventory")) {
                this.playerInstance.func_70020_e(this.playerNBT);
            }
            this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
        }
        if (this.top && this.pair != null) {
            this.occupied = ((TileEntityShellStorage)this.pair).occupied;
            this.syncing = ((TileEntityShellStorage)this.pair).syncing;
            this.hasPower = ((TileEntityShellStorage)this.pair).hasPower;
            this.playerInstance = ((TileEntityShellStorage)this.pair).playerInstance;
            this.prevPlayerName = ((TileEntityShellStorage)this.pair).prevPlayerName;
            this.occupationTime = ((TileEntityShellStorage)this.pair).occupationTime;
        }
        super.func_73660_a();
        if (!this.top && this.occupied && !this.field_145850_b.field_72995_K && !this.syncing) {
            EntityPlayer player = this.field_145850_b.func_72924_a(this.playerName);
            if (player != null) {
                double d5;
                double d4;
                double d3 = player.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                double dist = MathHelper.func_76133_a((double)(d3 * d3 + (d4 = player.func_174813_aQ().field_72338_b - (double)this.field_174879_c.func_177956_o()) * d4 + (d5 = player.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5)) * d5));
                if (dist > 0.75) {
                    this.occupied = false;
                    this.playerName = "";
                    IBlockState state2 = this.field_145850_b.func_180495_p(this.field_174879_c);
                    this.field_145850_b.func_184138_a(this.field_174879_c, state2, state2, 3);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
                }
            } else {
                this.occupied = false;
                this.playerName = "";
                IBlockState state3 = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state3, state3, 3);
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
            }
        }
        if (this.syncing && this.occupationTime > 0) {
            --this.occupationTime;
            if (this.occupationTime == 0) {
                if (this.vacating) {
                    if (!this.field_145850_b.field_72995_K && !this.top) {
                        state = this.field_145850_b.func_180495_p(this.field_174879_c);
                        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
                        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
                        ShellHandler.removeShell(this.playerName, this);
                    }
                    this.vacating = false;
                    this.occupied = false;
                    this.syncing = false;
                    this.playerName = "";
                    this.prevPlayerName = "";
                    this.playerNBT = new NBTTagCompound();
                } else if (!this.field_145850_b.field_72995_K && this.occupied && this.isPowered() && !this.playerName.equalsIgnoreCase("") && !this.top && !ShellHandler.isShellAlreadyRegistered(this)) {
                    ShellHandler.addShell(this.playerName, this, true);
                    this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && !this.top) {
            if (!this.isPowered() && ShellHandler.isShellAlreadyRegistered(this)) {
                ShellHandler.removeShell(this.playerName, this);
                this.hasPower = false;
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
            } else if (this.playerNBT.func_74764_b("Inventory") && this.isPowered() && !this.playerName.equalsIgnoreCase("") && !ShellHandler.isShellAlreadyRegistered(this)) {
                ShellHandler.addShell(this.playerName, this, true);
                this.hasPower = true;
                this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), true);
            }
            if (this.powerAmount() >= (float)Sync.config.shellStoragePowerRequirement && !this.hasPower) {
                this.hasPower = true;
                ShellHandler.addShell(this.playerName, this, true);
                state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
            if (this.powerAmount() < (float)Sync.config.shellStoragePowerRequirement && this.hasPower) {
                this.hasPower = false;
                ShellHandler.removeShell(this.playerName, this);
                state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
            this.powReceived = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer createPlayer(World world, UUID uuid, String playerName) {
        return new EntityOtherPlayerMP(world, uuid == null ? EntityHelper.getGameProfile((String)playerName) : EntityHelper.getGameProfile((UUID)uuid, (String)playerName));
    }

    public boolean isPowered() {
        if (this.top && this.pair != null) {
            return ((TileEntityShellStorage)this.pair).isPowered();
        }
        return (this.field_145850_b.func_175687_A(this.field_174879_c) != 0 || this.field_145850_b.func_175687_A(this.field_174879_c.func_177984_a()) != 0) && this.hasPower;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74757_a("occupied", this.occupied);
        tag.func_74757_a("syncing", this.canSavePlayer <= 0 && this.syncing);
        tag.func_74757_a("hasPower", this.hasPower);
        tag.func_74768_a("occupationTime", this.occupationTime);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.occupied = tag.func_74767_n("occupied");
        this.syncing = tag.func_74767_n("syncing");
        this.hasPower = tag.func_74767_n("hasPower");
        this.occupationTime = tag.func_74762_e("occupationTime");
        this.resync = true;
    }

    @Override
    public void reset() {
        super.reset();
        this.syncing = false;
        this.playerInstance = null;
        this.vacating = false;
        this.occupied = false;
        this.occupationTime = 0;
        this.prevPlayerName = "";
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY && !this.top || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (Sync.config.shellStoragePowerRequirement == 0) {
            return 0;
        }
        int pow = maxReceive;
        if (pow > Sync.config.shellStoragePowerRequirement) {
            pow = Sync.config.shellStoragePowerRequirement;
        }
        if (!simulate) {
            this.powReceived = (int)((float)this.powReceived + (float)pow * (float)Sync.config.ratioRF);
        }
        return pow;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return !this.top && Sync.config.shellStoragePowerRequirement != 0;
    }
}

