/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.util.ByteBufUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.DataSerializerEntry;

public class ASDataSerializers {
    public static DataSerializer<Long> LONG = new DataSerializer<Long>(){

        public void write(PacketBuffer buf, Long value) {
            buf.writeLongLE(value.longValue());
        }

        public Long read(PacketBuffer buf) {
            return buf.readLongLE();
        }

        public DataParameter<Long> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Long copyValue(Long value) {
            return new Long(value);
        }
    };
    public static DataSerializer<Vector3> VECTOR = new DataSerializer<Vector3>(){

        public void write(PacketBuffer buf, Vector3 value) {
            buf.writeDouble(value.getX());
            buf.writeDouble(value.getY());
            buf.writeDouble(value.getZ());
        }

        public Vector3 read(PacketBuffer buf) throws IOException {
            return new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public DataParameter<Vector3> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public Vector3 copyValue(Vector3 value) {
            return value.clone();
        }
    };
    public static DataSerializer<FluidStack> FLUID = new DataSerializer<FluidStack>(){

        public void write(PacketBuffer buf, FluidStack value) {
            buf.writeBoolean(value != null);
            if (value != null) {
                ByteBufUtils.writeFluidStack((ByteBuf)buf, value);
            }
        }

        public FluidStack read(PacketBuffer buf) throws IOException {
            return buf.readBoolean() ? ByteBufUtils.readFluidStack((ByteBuf)buf) : null;
        }

        public DataParameter<FluidStack> func_187161_a(int id) {
            return new DataParameter(id, (DataSerializer)this);
        }

        public FluidStack copyValue(FluidStack value) {
            return value == null ? null : value.copy();
        }
    };

    public static void registerSerializers() {
        CommonProxy.registryPrimer.register(new DataSerializerEntry(FLUID).setRegistryName("astralsorcery", "serializer_fluid"));
        CommonProxy.registryPrimer.register(new DataSerializerEntry(LONG).setRegistryName("astralsorcery", "serializer_long"));
        CommonProxy.registryPrimer.register(new DataSerializerEntry(VECTOR).setRegistryName("astralsorcery", "serializer_vec3d"));
    }
}

