/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.ynot;

import java.util.function.Function;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.SidedEnvironment;
import mcjty.xnet.api.IXNet;
import mcjty.xnet.api.channels.IChannelType;
import mcjty.xnet.api.channels.IConnectable;
import mekanism.api.gas.IGasHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import pl.asie.ynot.YNotConnectable;
import pl.asie.ynot.flamingo.FlamingoChannelType;
import pl.asie.ynot.mekanism.GasChannelType;
import pl.asie.ynot.oc.OCChannelType;

@Mod(modid="ynot", name="YNot", version="0.2.4", dependencies="required-after:xnet@[1.8.0,)", updateJSON="http://asie.pl/files/minecraft/update/ynot.json", acceptedMinecraftVersions="[1.12.2]")
public class YNot {
    public static final ResourceLocation iconGui = new ResourceLocation("ynot", "textures/gui/gui.png");
    private static Configuration config;
    public static int maxGasRateAdvanced;
    public static int maxGasRateNormal;
    private static boolean enableMekanismGas;
    private static boolean enableWiggles;
    private static boolean enableOC;
    @CapabilityInject(value=IGasHandler.class)
    private static Capability<IGasHandler> capMekGasHandler;
    @CapabilityInject(value=Environment.class)
    private static Capability<Environment> capOCEnv;
    @CapabilityInject(value=SidedEnvironment.class)
    private static Capability<SidedEnvironment> capOCSidedEnv;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        if (Loader.isModLoaded((String)"mekanism")) {
            enableMekanismGas = config.getBoolean("mekanismGasChannel", "features", true, "Mekanism Gas Channel support for XNet");
            maxGasRateAdvanced = config.getInt("mekanismGasMaxRateAdvanced", "balance", 1280, 1, Integer.MAX_VALUE, "Maximum transfer rate for Mekanism Gas and advanced connectors");
            maxGasRateNormal = config.getInt("mekanismGasMaxRateNormal", "balance", 256, 1, Integer.MAX_VALUE, "Maximum transfer rate for Mekanism Gas and normal connectors");
        }
        if (Loader.isModLoaded((String)"flamingo")) {
            enableWiggles = config.getBoolean("flamingoWiggles", "features", true, "Don't question it.");
        }
        if (Loader.isModLoaded((String)"opencomputers")) {
            enableOC = config.getBoolean("opencomputersCable", "features", true, "Adds the ability to send network messages and use components.");
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLInterModComms.sendFunctionMessage((String)"xnet", (String)"getXNet", (String)"pl.asie.ynot.YNot$XNetHook");
    }

    public static class XNetHook
    implements Function<IXNet, Void> {
        @Override
        public Void apply(IXNet xNet) {
            boolean needsCustomConnections = false;
            if (enableMekanismGas) {
                xNet.registerChannelType((IChannelType)new GasChannelType());
                YNotConnectable.add(capMekGasHandler);
                YNotConnectable.add(capMekGasHandler.getClass());
                needsCustomConnections = true;
            }
            if (enableWiggles) {
                FlamingoChannelType type = new FlamingoChannelType();
                xNet.registerChannelType((IChannelType)type);
                xNet.registerConnectable((IConnectable)type);
            }
            if (enableOC) {
                xNet.registerChannelType((IChannelType)new OCChannelType());
                YNotConnectable.add(capOCEnv, capOCSidedEnv);
                needsCustomConnections = true;
            }
            if (needsCustomConnections) {
                xNet.registerConnectable((IConnectable)YNotConnectable.INSTANCE);
            }
            return null;
        }
    }
}

