/*
 * Decompiled with CFR 0.152.
 */
package org.dave.skybonsais.integration;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.dave.bonsaitrees.api.BonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiIntegration;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.ITreeTypeRegistry;
import org.dave.bonsaitrees.api.TreeTypeSimple;
import org.dave.skybonsais.integration.SkyOrchardsDropChances;
import org.dave.skybonsais.util.Logz;
import sky_orchards.blocks.EnumWood;

@BonsaiIntegration(mod="sky_orchards")
public class SkyOrchards
implements IBonsaiIntegration {
    private void addItemStackDrop(TreeTypeSimple treeType, Block block, int amount, float chance) {
        if (amount <= 0 || chance <= 0.0f) {
            return;
        }
        treeType.addDrop(new ItemStack(block, amount, 0), chance);
    }

    private void addItemStackDrop(TreeTypeSimple treeType, Item item, int amount, float chance) {
        if (amount <= 0 || chance <= 0.0f) {
            return;
        }
        treeType.addDrop(new ItemStack(item, amount, 0), chance);
    }

    public void registerTrees(ITreeTypeRegistry registry) {
        for (EnumWood wood : EnumWood.values()) {
            TreeTypeSimple treeType = new TreeTypeSimple("sky_orchard:" + wood.func_176610_l(), new ItemStack(wood.getSapling()));
            this.addItemStackDrop(treeType, wood.getSapling(), SkyOrchardsDropChances.saplingAmount, SkyOrchardsDropChances.saplingChance);
            this.addItemStackDrop(treeType, Items.field_151055_y, SkyOrchardsDropChances.stickAmount, SkyOrchardsDropChances.stickChance);
            this.addItemStackDrop(treeType, wood.getResin(), SkyOrchardsDropChances.resinAmount, SkyOrchardsDropChances.resinChance);
            this.addItemStackDrop(treeType, Blocks.field_150364_r, SkyOrchardsDropChances.logAmount, SkyOrchardsDropChances.logChance);
            this.addItemStackDrop(treeType, wood.getLeaves(), SkyOrchardsDropChances.leafAmount, SkyOrchardsDropChances.leafChance);
            this.addItemStackDrop(treeType, wood.getAcorn(), SkyOrchardsDropChances.acornAmount, SkyOrchardsDropChances.acornChance);
            this.addItemStackDrop(treeType, wood.getAmber(), SkyOrchardsDropChances.amberAmount, SkyOrchardsDropChances.amberChance);
            if (!wood.getLeafDrop().equalsIgnoreCase("unused") && !wood.getLeafDrop().equalsIgnoreCase("null")) {
                String[] finalEntry = wood.getLeafDrop().trim().split("#");
                if (finalEntry.length != 4) continue;
                ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(finalEntry[0])), Integer.valueOf(finalEntry[1]).intValue(), Integer.valueOf(finalEntry[2]).intValue());
                int chanceInv = Integer.valueOf(finalEntry[3]);
                float chance = chanceInv == 0 ? 0.0f : 1.0f / (float)chanceInv;
                treeType.addDrop(stack, chance);
            }
            registry.registerTreeType((IBonsaiIntegration)this, (IBonsaiTreeType)treeType);
        }
    }

    public void generateTree(IBonsaiTreeType type, World world, BlockPos pos, Random rand) {
        if (!(type.getExampleStack().func_77973_b() instanceof ItemBlock)) {
            Logz.warn("Sapling is no ItemBlock! This should not be happening!", new Object[0]);
            return;
        }
        Block sapling = ((ItemBlock)type.getExampleStack().func_77973_b()).func_179223_d();
        if (!(sapling instanceof BlockSapling)) {
            Logz.info("Not an ore sapling", new Object[0]);
            return;
        }
        world.func_175656_a(pos, sapling.func_176223_P());
        BlockSapling oreSapling = (BlockSapling)sapling;
        oreSapling.func_176476_e(world, pos, null, rand);
    }
}

