/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableBiMap;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public enum ScrollWheelHandler implements Consumer<ContainerContext>
{
    ONEITEMIN(-1),
    ONEITEMOUT(1);

    private final int moveAmount;

    private ScrollWheelHandler(int amount) {
        this.moveAmount = amount;
    }

    @Override
    @Nullable
    public void accept(ContainerContext context) {
        Slot source;
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        ItemStack is = InventoryHandler.INSTANCE.getItemStack(context);
        if (is == null) {
            return;
        }
        ImmutableBiMap<IInventory, InventoryHandler.InventoryMapping> mapping = context.mapping;
        if (this.moveAmount < 0 && is.func_77976_d() > is.func_190916_E()) {
            source = InventoryHandler.INSTANCE.findStackWithItem(is, context);
        } else if (this.moveAmount > 0) {
            source = context.slot;
        } else {
            return;
        }
        if (source == null) {
            return;
        }
        if (InventorySorter.INSTANCE.slotblacklist.contains(source.getClass().getName())) {
            return;
        }
        if (InventorySorter.INSTANCE.slotblacklist.contains(context.slot.getClass().getName())) {
            return;
        }
        if (!source.func_82869_a((EntityPlayer)context.player)) {
            return;
        }
        if (!source.func_75214_a(is)) {
            return;
        }
        ItemStack sourceStack = InventoryHandler.INSTANCE.getItemStack(source);
        if (sourceStack.func_190926_b()) {
            return;
        }
        ItemStack iscopy = sourceStack.func_77946_l();
        iscopy.func_190920_e(1);
        ArrayList<InventoryHandler.InventoryMapping> mappingCandidates = new ArrayList<InventoryHandler.InventoryMapping>();
        if (this.moveAmount < 0) {
            InventoryHandler.InventoryMapping inventoryMapping = new InventoryHandler.InventoryMapping(context.slot.field_75224_c, context.player.field_71070_bA, context.slot.field_75224_c, context.slot.getClass());
            mappingCandidates.add(inventoryMapping);
            inventoryMapping.begin = context.slot.field_75222_d;
            inventoryMapping.end = context.slot.field_75222_d;
        } else if (context.player.field_71070_bA == context.player.field_71069_bz) {
            if (InventoryHandler.preferredOrders.containsKey(context.slotMapping.inv)) {
                mappingCandidates.addAll(InventoryHandler.preferredOrders.get(context.slotMapping.inv).stream().map(arg_0 -> mapping.get(arg_0)).collect(Collectors.toList()));
            }
            Collections.reverse(mappingCandidates);
        } else {
            for (Map.Entry<IInventory, InventoryHandler.InventoryMapping> entry : InventoryHandler.INSTANCE.getSortedMapping(context)) {
                if (entry.getValue().proxy == context.slot.field_75224_c || InventorySorter.INSTANCE.slotblacklist.contains(entry.getValue().slotType.getName())) continue;
                mappingCandidates.add(entry.getValue());
            }
        }
        Collections.reverse(mappingCandidates);
        for (InventoryHandler.InventoryMapping mappingCandidate : mappingCandidates) {
            if (mappingCandidate.inv == ContainerContext.PLAYER_OFFHAND && this.moveAmount > 0) {
                boolean empty = true;
                for (ItemStack itemStack : context.player.field_71071_by.field_184439_c) {
                    if (itemStack.func_190926_b()) continue;
                    empty = false;
                }
                if (empty) continue;
            }
            if (mappingCandidate.inv == ContainerContext.PLAYER_HOTBAR && this.moveAmount > 0) {
                boolean hasTarget = false;
                boolean found = false;
                for (int i = 0; i < 9; ++i) {
                    ItemStack itemStack = (ItemStack)context.player.field_71071_by.field_70462_a.get(i);
                    if (ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)sourceStack) && itemStack.func_190916_E() < itemStack.func_77976_d()) {
                        hasTarget = true;
                        continue;
                    }
                    if (!ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)sourceStack)) continue;
                    found = true;
                }
                if (!hasTarget && found) continue;
            }
            InventoryHandler.INSTANCE.moveItemToOtherInventory(context, iscopy, mappingCandidate.begin, mappingCandidate.end + 1, this.moveAmount < 0);
            if (iscopy.func_190916_E() != 0) continue;
            sourceStack.func_190917_f(-1);
            if (sourceStack.func_190916_E() == 0) {
                source.func_75215_d(ItemStack.field_190927_a);
                break;
            }
            source.func_75218_e();
            break;
        }
    }
}

