/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.api.client.head;

import java.util.Map;
import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.model.ModelPolarBear;
import net.minecraft.client.model.ModelQuadruped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HeadBase<E extends EntityLivingBase> {
    public static BooleanSupplier acidEyesBooleanSupplier = () -> false;
    public ModelRenderer[] headModel = null;
    public Object headInfo = null;
    public float[] headJoint = new float[3];
    public float[] eyeOffset = new float[]{0.0f, 0.25f, 0.25f};
    public float[] irisColour = new float[]{0.9f, 0.9f, 0.9f};
    public float[] pupilColour = new float[]{0.0f, 0.0f, 0.0f};
    public float halfInterpupillaryDistance = 0.125f;
    public float eyeScale = 0.75f;
    public float headTop = 0.5f;
    public float headFront = 0.25f;
    public Random livingRand = new Random();
    public int[] acidTime;

    public HeadBase setHeadJoint(float jointX, float jointY, float jointZ) {
        this.headJoint = new float[]{jointX, jointY, jointZ};
        return this;
    }

    public HeadBase setEyeOffset(float offsetX, float offsetY, float offsetZ) {
        this.eyeOffset = new float[]{offsetX, offsetY, offsetZ};
        return this;
    }

    public HeadBase setHalfInterpupillaryDistance(float dist) {
        this.halfInterpupillaryDistance = dist;
        return this;
    }

    public HeadBase setEyeScale(float scale) {
        this.eyeScale = scale;
        return this;
    }

    public float[] getHeadJointOffset(E living, float partialTick, int eye) {
        this.headJoint[0] = -(this.headModel[0].field_78800_c / 16.0f);
        this.headJoint[1] = -(this.headModel[0].field_78797_d / 16.0f);
        this.headJoint[2] = -(this.headModel[0].field_78798_e / 16.0f);
        return this.headJoint;
    }

    public float[] getEyeOffsetFromJoint(E living, float partialTick, int eye) {
        return this.eyeOffset;
    }

    public int getEyeCount(E living) {
        return 2;
    }

    public float maxEyeSizeGrowth(E living, int eye) {
        return 0.0f;
    }

    public float getEyeSideOffset(E living, float partialTick, int eye) {
        return eye == 0 ? this.halfInterpupillaryDistance : -this.halfInterpupillaryDistance;
    }

    public float getEyeScale(E living, float partialTick, int eye) {
        return this.eyeScale;
    }

    public float getEyeRotation(E living, float partialTick, int eye) {
        return 0.0f;
    }

    public float getPupilScale(E living, float partialTick, int eye) {
        if (acidEyesBooleanSupplier.getAsBoolean() || (Integer)living.func_184212_Q().func_187225_a(EntityLivingBase.field_184633_f) > 0) {
            this.livingRand.setSeed(Math.abs(living.hashCode()) * 1000);
            int eyeCount = this.getEyeCount(living);
            if (this.acidTime == null || this.acidTime.length < eyeCount) {
                this.acidTime = new int[eyeCount];
            }
            for (int i = 0; i < eyeCount; ++i) {
                this.acidTime[i] = 20 + this.livingRand.nextInt(20);
            }
            return 0.3f + ((float)Math.sin(Math.toRadians(((float)((EntityLivingBase)living).field_70173_aa + partialTick) / (float)this.acidTime[eye] * 360.0f)) + 1.0f) / 2.0f;
        }
        return 1.0f + 0.35f * ((float)((EntityLivingBase)living).field_70725_aQ + partialTick) / 20.0f;
    }

    public float[] getIrisColours(E living, float partialTick, int eye) {
        return this.irisColour;
    }

    public float[] getPupilColours(E living, float partialTick, int eye) {
        return this.pupilColour;
    }

    public float getHeadTopOffsetFromJoint(E living, float partialTick, int eye) {
        return this.headTop;
    }

    public float getHeadFrontOffsetFromJoint(E living, float partialTick, int eye) {
        return this.headFront;
    }

    public float getHeadYaw(E living, float partialTick, int eye) {
        return (float)Math.toDegrees(this.headModel[0].field_78796_g);
    }

    public float getHeadPitch(E living, float partialTick, int eye) {
        return (float)Math.toDegrees(this.headModel[0].field_78795_f);
    }

    public float getHeadRoll(E living, float partialTick, int eye) {
        return (float)Math.toDegrees(this.headModel[0].field_78808_h);
    }

    public boolean affectedByInvisibility(E living, int eye) {
        return true;
    }

    public boolean doesEyeGlow(E living, int eye) {
        return false;
    }

    public void preChildEntHeadRenderCalls(E living, RenderLivingBase render) {
        if (living.func_70631_g_()) {
            float modelScale = 0.0625f;
            ModelBase model = render.func_177087_b();
            if (model instanceof ModelBiped) {
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                GlStateManager.func_179109_b((float)0.0f, (float)(16.0f * modelScale), (float)0.0f);
            } else if (model instanceof ModelQuadruped) {
                if (model instanceof ModelPolarBear) {
                    GlStateManager.func_179152_a((float)0.6666667f, (float)0.6666667f, (float)0.6666667f);
                }
                GlStateManager.func_179109_b((float)0.0f, (float)(((ModelQuadruped)model).field_78145_g * modelScale), (float)(((ModelQuadruped)model).field_78151_h * modelScale));
            } else if (model instanceof ModelChicken) {
                GlStateManager.func_179109_b((float)0.0f, (float)(5.0f * modelScale), (float)(2.0f * modelScale));
            }
        }
    }

    public HeadBase clone() {
        try {
            HeadBase clone = (HeadBase)this.getClass().newInstance();
            for (int i = 0; i < 3; ++i) {
                clone.headJoint[i] = this.headJoint[i];
                clone.eyeOffset[i] = this.eyeOffset[i];
            }
            clone.halfInterpupillaryDistance = this.halfInterpupillaryDistance;
            clone.eyeScale = this.eyeScale;
            return clone;
        }
        catch (Exception exception) {
            return new HeadBase<E>();
        }
    }

    public static void registerHeadHelper(Class<? extends EntityLivingBase> clz, HeadBase base) {
        try {
            Class<?> clzz = Class.forName("me.ichun.mods.ichunutil.client.entity.head.HeadHandler");
            Map modelOffsetHelpers = (Map)ObfuscationReflectionHelper.getPrivateValue(clzz, null, (String[])new String[]{"modelOffsetHelpers"});
            modelOffsetHelpers.put(clz, base);
        }
        catch (Exception e) {
            System.out.println("Error registering head helper class: " + clz.getName());
            e.printStackTrace();
        }
    }
}

