/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.blocks.cake;

import com.mrbysco.telepastries.TelePastries;
import com.mrbysco.telepastries.blocks.BlockPastryBase;
import com.mrbysco.telepastries.config.TeleConfig;
import com.mrbysco.telepastries.util.CakeTeleporter;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockCakeBase
extends BlockPastryBase {
    public static final PropertyInteger BITES = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)6);
    protected static final AxisAlignedBB[] CAKE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.1875, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.3125, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.4375, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.5625, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.6875, 0.0, 0.0625, 0.9375, 0.5, 0.9375), new AxisAlignedBB(0.8125, 0.0, 0.0625, 0.9375, 0.5, 0.9375)};

    public BlockCakeBase(String registry) {
        super(Material.field_151568_F);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(TelePastries.teleTab);
        this.setRegistryName(registry);
        this.func_149663_c("telepastries:" + registry);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CAKE_AABB[(Integer)state.func_177229_b((IProperty)BITES)];
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (this.consumeCake() && stack != ItemStack.field_190927_a && stack.func_77973_b() == this.getRefillItem()) {
            if (playerIn.field_71075_bZ.field_75098_d) {
                worldIn.func_180501_a(pos, this.func_176203_a(0), 2);
            } else {
                int biteAmount = this.getBites(state) - 1;
                if (biteAmount >= 0) {
                    worldIn.func_180501_a(pos, this.func_176203_a(biteAmount), 2);
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        if (!worldIn.field_72995_K && worldIn.field_73011_w.getDimension() != this.getCakeDimension(worldIn)) {
            if (playerIn.func_71043_e(true) || playerIn.func_184812_l_()) {
                if (TeleConfig.general.resetPastry && stack.func_77973_b() == Item.func_111206_d((String)TeleConfig.general.resetItem)) {
                    this.removeDimensionPosition((EntityPlayerMP)playerIn, this.getCakeDimension(worldIn));
                    if (Item.func_111206_d((String)TeleConfig.general.resetItem) == Items.field_151117_aB && !playerIn.field_71075_bZ.field_75098_d) {
                        stack = new ItemStack(Items.field_151133_ar);
                    }
                } else {
                    this.eatCake(worldIn, pos, state, playerIn);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private void eatCake(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        int l = (Integer)state.func_177229_b((IProperty)BITES);
        if (l < 6) {
            if (!playerIn.field_71075_bZ.field_75098_d && this.consumeCake()) {
                playerIn.func_71029_a(StatList.field_188076_J);
                playerIn.func_71024_bL().func_75122_a(2, 0.1f);
                worldIn.func_180501_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(l + 1)), 3);
            }
            if (!ForgeHooks.onTravelToDimension((Entity)playerIn, (int)this.getCakeDimension(worldIn))) {
                return;
            }
            this.teleportToDimension(worldIn, pos, playerIn);
        } else if (!playerIn.field_71075_bZ.field_75098_d && this.consumeCake()) {
            worldIn.func_175698_g(pos);
        }
    }

    public void teleportToDimension(World world, BlockPos pos, EntityPlayer player) {
        if (!(player.field_70128_L || world.field_72995_K || player.func_184218_aH() || player.func_184207_aI() || !player.func_184222_aU())) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            CakeTeleporter teleporter = new CakeTeleporter(playerMP.func_184102_h().func_71218_a(this.getCakeDimension(world)), playerMP.func_180425_c());
            teleporter.addDimensionPosition(playerMP, playerMP.field_71093_bK, playerMP.func_180425_c().func_177963_a(0.0, 0.5, 0.0));
            teleporter.teleportToDimension((EntityPlayer)playerMP, this.getCakeDimension(world), playerMP.func_180425_c());
        }
    }

    public Item getRefillItem() {
        return null;
    }

    public int getCakeDimension() {
        return 0;
    }

    public int getCakeDimension(World worldIn) {
        return this.getCakeDimension();
    }

    public boolean consumeCake() {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BITES, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BITES);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BITES});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return (7 - (Integer)blockState.func_177229_b((IProperty)BITES)) * 2;
    }

    protected int getBites(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)BITES);
    }

    protected void removeDimensionPosition(EntityPlayerMP player, int dim) {
        NBTTagCompound playerData = player.getEntityData();
        NBTTagCompound data = this.getTag(playerData, "PlayerPersisted");
        if (data.func_74764_b("telepastries:" + dim)) {
            data.func_82580_o("telepastries:" + dim);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("telepastries.pastry.reset.complete", new Object[]{dim}));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("telepastries.pastry.reset.failed", new Object[]{dim}));
        }
        playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
    }

    protected NBTTagCompound getTag(NBTTagCompound tag, String key) {
        if (tag == null || !tag.func_74764_b(key)) {
            return new NBTTagCompound();
        }
        return tag.func_74775_l(key);
    }
}

