/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="telepastries", name="TelePastries", category="")
@Config.LangKey(value="telepastries.config.title")
public class TeleConfig {
    @Config.Comment(value={"General TelePastry settings"})
    public static General general = new General();
    @Config.Comment(value={"General pastry settings"})
    public static Pastries pastries = new Pastries();
    @Config.Comment(value={"Mod Compat pastry settings"})
    public static CompatPastries pastriesCompat = new CompatPastries();

    @Mod.EventBusSubscriber(modid="telepastries")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("telepastries")) {
                ConfigManager.sync((String)"telepastries", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class CompatPastries {
        @Config.Comment(value={"Twilight Forest Pastry settings"})
        public final TwilightForest twilightForest = new TwilightForest();
        @Config.Comment(value={"Lost Cities Pastry settings"})
        public final LostCities lostCities = new LostCities();
        @Config.Comment(value={"Hunting Dimension Pastry settings"})
        public final HuntingDimension huntingDimension = new HuntingDimension();

        public static class HuntingDimension {
            @Config.Comment(value={"Defines if the Hunting Dimension Cake gets partly consumed when eaten [default: true]"})
            public boolean consumeHuntingDimensionCake = true;
            @Config.Comment(value={"Set the refill item used by Hunting Dimension Cake (Only change if you know what you're doing) [modid:itemname]."})
            public String huntingDimensionCakeRefillItem = "minecraft:arrow";
        }

        public static class LostCities {
            @Config.Comment(value={"Defines if the Lost Cities Cake gets partly consumed when eaten [default: true]"})
            public boolean consumeLostCitiesCake = true;
            @Config.Comment(value={"Set the refill item used by Lost Cities Cake (Only change if you know what you're doing) [modid:itemname]."})
            public String lostCitiesCakeRefillItem = "minecraft:bed";
        }

        public static class TwilightForest {
            @Config.Comment(value={"Defines if the Twilight Forest Cake gets partly consumed when eaten [default: true]"})
            public boolean consumeTwilightForestCake = true;
            @Config.Comment(value={"Set the refill item used by Twilight Forest Cake (Only change if you know what you're doing) [modid:itemname]."})
            public String twilightForestCakeRefillItem = "minecraft:diamond";
        }
    }

    public static class Pastries {
        @Config.Comment(value={"Nether Pastry settings"})
        public final Nether nether = new Nether();
        @Config.Comment(value={"End Pastry settings"})
        public final End end = new End();
        @Config.Comment(value={"Overworld Pastry settings"})
        public final Overworld overworld = new Overworld();

        public static class Overworld {
            @Config.Comment(value={"Defines if the Overworld Cake gets partly consumed when eaten [default: true]"})
            public boolean consumeOverworldCake = true;
            @Config.Comment(value={"Set the refill item used by Overworld Cake (Only change if you know what you're doing) [modid:itemname]."})
            public String overworldCakeRefillItem = "minecraft:sapling";
        }

        public static class End {
            @Config.Comment(value={"Defines if the End Cake gets partly consumed when eaten [default: true]"})
            public boolean consumeEndCake = true;
            @Config.Comment(value={"Set the refill item used by End Cake (Only change if you know what you're doing) [modid:itemname]."})
            public String endCakeRefillItem = "minecraft:ender_eye";
        }

        public static class Nether {
            @Config.Comment(value={"Defines if the Nether Cake gets partly consumed when eaten [default: true]"})
            public boolean consumeNetherCake = true;
            @Config.Comment(value={"Set the refill item used by Nether Cake (Only change if you know what you're doing) [modid:itemname]."})
            public String netherCakeRefillItem = "minecraft:obsidian";
            @Config.Comment(value={"Defines if the Nether Cake should teleport the player 1x1 (Use this if you're replacing the Nether dimension with one that is 1x1) [default: false]."})
            public boolean netherCake1x1Logic = false;
        }
    }

    public static class General {
        @Config.Comment(value={"Defines if the pastry teleportation point can be reset with a milk bucket [default: false]"})
        public boolean resetPastry = false;
        @Config.Comment(value={"Defines the item needed to reset the pastry teleportation point [default: minecraft:milk_bucket]"})
        public String resetItem = "minecraft:milk_bucket";
    }
}

