/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepastries.util;

import com.mrbysco.telepastries.config.TeleConfig;
import mcjty.lostcities.config.LostCityConfiguration;
import net.darkhax.huntingdim.handler.ConfigurationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import twilightforest.TFConfig;

public class CakeTeleporter
extends Teleporter {
    private BlockPos position;

    public CakeTeleporter(WorldServer world, BlockPos position) {
        super(world);
        this.position = position;
    }

    public void teleportToDimension(EntityPlayer player, int dimension, BlockPos pos) {
        BlockPos dimPos = this.getDimensionPosition((EntityPlayerMP)player, dimension, pos);
        this.teleportToDimension(player, dimension, (double)dimPos.func_177958_n() + 0.5, dimPos.func_177956_o(), (double)dimPos.func_177952_p() + 0.5);
    }

    public void teleportToDimension(EntityPlayer player, int dimension, double x, double y, double z) {
        int oldDimension = player.func_130014_f_().field_73011_w.getDimension();
        EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
        this.field_85192_a.func_184148_a(null, x + 0.5, y + 0.5, z + 0.5, SoundEvents.field_187812_eh, SoundCategory.MASTER, 0.25f, this.field_85192_a.field_73012_v.nextFloat() * 0.4f + 0.8f);
        if (!player.field_71075_bZ.field_75098_d) {
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 200, 200, false, false));
        }
        if (this.field_85192_a != null && this.field_85192_a.func_73046_m() != null) {
            PlayerList playerList = this.field_85192_a.func_73046_m().func_184103_al();
            playerList.transferPlayerToDimension(entityPlayerMP, dimension, (Teleporter)this);
            player.func_70634_a(x, y, z);
            if (dimension == -1) {
                this.relocateInNether(entityPlayerMP, x, y, z);
            }
            if (dimension == 1) {
                this.endPlacement(entityPlayerMP);
            }
            if (oldDimension == 1) {
                player.func_70634_a(x, y, z);
                this.field_85192_a.func_72838_d((Entity)player);
                this.field_85192_a.func_72866_a((Entity)player, false);
            }
            if (dimension != 0) {
                this.customCompat(entityPlayerMP, dimension, x, y, z);
            }
        } else {
            throw new IllegalArgumentException("Dimension: " + dimension + " doesn't exist!");
        }
    }

    private void customCompat(EntityPlayerMP playerMP, int dimension, double x, double y, double z) {
        if (Loader.isModLoaded((String)"twilightforest") && dimension == TFConfig.dimension.dimensionID) {
            this.twilightPlacement(playerMP, x, y, z);
        }
        if (Loader.isModLoaded((String)"lostcities") && dimension == LostCityConfiguration.DIMENSION_ID) {
            this.lostCitiesPlacement(playerMP, x, y, z);
        }
        if (Loader.isModLoaded((String)"huntingdim") && dimension == ConfigurationHandler.dimensionId) {
            this.huntingDimensionPlacement(playerMP, x, y, z);
        }
    }

    public void addDimensionPosition(EntityPlayerMP player, int oldDim, BlockPos position) {
        NBTTagCompound playerData = player.getEntityData();
        NBTTagCompound data = this.getTag(playerData, "PlayerPersisted");
        if (oldDim == 1) {
            BlockPos spawnPlatform = player.func_184102_h().func_71218_a(1).func_180504_m();
            data.func_74772_a("telepastries:" + oldDim, spawnPlatform.func_177986_g());
        } else {
            data.func_74772_a("telepastries:" + oldDim, position.func_177986_g());
        }
        playerData.func_74782_a("PlayerPersisted", (NBTBase)data);
    }

    public BlockPos getDimensionPosition(EntityPlayerMP player, int dim, BlockPos position) {
        NBTTagCompound playerData = player.getEntityData();
        NBTTagCompound data = this.getTag(playerData, "PlayerPersisted");
        BlockPos dimPos = position;
        if (data.func_74764_b("telepastries:" + dim)) {
            dimPos = BlockPos.func_177969_a((long)data.func_74763_f("telepastries:" + dim));
        }
        return dimPos;
    }

    public boolean hasDimensionPosition(EntityPlayerMP player, int dim) {
        NBTTagCompound playerData = player.getEntityData();
        NBTTagCompound data = this.getTag(playerData, "PlayerPersisted");
        return data.func_74764_b("telepastries:" + dim);
    }

    private NBTTagCompound getTag(NBTTagCompound tag, String key) {
        if (tag == null || !tag.func_74764_b(key)) {
            return new NBTTagCompound();
        }
        return tag.func_74775_l(key);
    }

    public void func_180266_a(Entity entityIn, float rotationYaw) {
        entityIn.func_70107_b((double)this.position.func_177958_n(), (double)this.position.func_177956_o(), (double)this.position.func_177952_p());
        entityIn.field_70159_w = 0.0;
        entityIn.field_70181_x = 0.0;
        entityIn.field_70179_y = 0.0;
    }

    private void endPlacement(EntityPlayerMP player) {
        int i = MathHelper.func_76128_c((double)player.field_70165_t);
        int j = MathHelper.func_76128_c((double)player.field_70163_u) - 1;
        int k = MathHelper.func_76128_c((double)player.field_70161_v);
        for (int j1 = -2; j1 <= 2; ++j1) {
            for (int k1 = -2; k1 <= 2; ++k1) {
                for (int l1 = -1; l1 < 3; ++l1) {
                    int i2 = i + k1 * 1 + j1 * 0;
                    int j2 = j + l1;
                    int k2 = k + k1 * 0 - j1 * 1;
                    boolean flag = l1 < 0;
                    this.field_85192_a.func_175656_a(new BlockPos(i2, j2, k2), flag ? Blocks.field_150343_Z.func_176223_P() : Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    private void relocateInNether(EntityPlayerMP playerMP, double x, double y, double z) {
        if (TeleConfig.pastries.nether.netherCake1x1Logic) {
            this.protectPlayer(playerMP, new BlockPos(x, y, z));
        } else if (this.hasDimensionPosition(playerMP, -1)) {
            this.protectPlayer(playerMP, new BlockPos(x, y, z));
        } else {
            double moveFactor = 0.125;
            double d0 = MathHelper.func_151237_a((double)(x * moveFactor), (double)(this.field_85192_a.func_175723_af().func_177726_b() + 16.0), (double)(this.field_85192_a.func_175723_af().func_177728_d() - 16.0));
            double d1 = MathHelper.func_151237_a((double)(z * moveFactor), (double)(this.field_85192_a.func_175723_af().func_177736_c() + 16.0), (double)(this.field_85192_a.func_175723_af().func_177733_e() - 16.0));
            double d2 = 8.0;
            d0 = MathHelper.func_76125_a((int)((int)d0), (int)-29999872, (int)29999872);
            d1 = MathHelper.func_76125_a((int)((int)d1), (int)-29999872, (int)29999872);
            double newY = MathHelper.func_151237_a((double)y, (double)70.0, (double)(this.field_85192_a.func_72940_L() - 10));
            this.protectPlayer(playerMP, new BlockPos(d0, newY, d1));
        }
    }

    private void protectPlayer(EntityPlayerMP playerIn, BlockPos position) {
        boolean foundSuitablePlatform = false;
        if (this.field_85192_a.field_73011_w.getDimension() != 0) {
            for (int j1 = 0; j1 < 5; ++j1) {
                BlockPos checkingPos = position.func_177982_a(0, -j1, 0);
                if (!this.field_85192_a.func_180495_p(checkingPos).func_185913_b()) continue;
                foundSuitablePlatform = true;
                break;
            }
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos testPos;
                    if (!(x != -2 && x != 2 || z != -2 && z != 2)) {
                        testPos = new BlockPos((Vec3i)position.func_177982_a(x, 3, z));
                        if (this.field_85192_a.func_180495_p(testPos).func_185913_b() || !this.field_85192_a.func_180495_p(testPos).func_185904_a().func_76224_d()) continue;
                        this.field_85192_a.func_175656_a(testPos, Blocks.field_150343_Z.func_176223_P());
                        continue;
                    }
                    if (this.field_85192_a.func_180495_p(position.func_177982_a(x, 3, z)).func_185904_a().func_76224_d()) {
                        this.field_85192_a.func_175656_a(position.func_177982_a(x, 3, z), Blocks.field_150343_Z.func_176223_P());
                    }
                    if (foundSuitablePlatform || this.field_85192_a.func_180495_p(testPos = new BlockPos((Vec3i)position.func_177982_a(x, -2, z))).func_185913_b() && !this.field_85192_a.func_180495_p(testPos).func_185904_a().func_76224_d()) continue;
                    this.field_85192_a.func_175656_a(testPos, Blocks.field_150343_Z.func_176223_P());
                }
            }
        }
        BlockPos platformPos = new BlockPos((Vec3i)position.func_177982_a(1, 2, 1));
        for (int y = 1; y <= 3; ++y) {
            if (!this.field_85192_a.func_180495_p(position.func_177982_a(0, y, 0)).func_185913_b() && !this.field_85192_a.func_180495_p(position.func_177982_a(0, y, 0)).func_185904_a().func_76224_d()) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos testPos = position.func_177982_a(x, y, z);
                    if (!this.field_85192_a.func_180495_p(testPos).func_185913_b() && !this.field_85192_a.func_180495_p(testPos).func_185904_a().func_76224_d()) continue;
                    this.field_85192_a.func_175698_g(testPos);
                }
            }
        }
        playerIn.func_70012_b((double)position.func_177958_n() + 0.5, (double)platformPos.func_177956_o(), (double)position.func_177952_p() + 0.5, 90.0f, 0.0f);
        playerIn.func_70634_a((double)position.func_177958_n() + 0.5, (double)platformPos.func_177956_o(), (double)position.func_177952_p() + 0.5);
    }

    @Optional.Method(modid="twilightforest")
    private void twilightPlacement(EntityPlayerMP playerMP, double x, double y, double z) {
        this.protectPlayer(playerMP, new BlockPos(x, y, z));
        playerMP.setSpawnChunk(new BlockPos((Entity)playerMP), true, this.field_85192_a.field_73011_w.getDimension());
    }

    @Optional.Method(modid="lostcities")
    private void lostCitiesPlacement(EntityPlayerMP playerMP, double x, double y, double z) {
        this.protectPlayer(playerMP, new BlockPos(x, y, z));
        playerMP.setSpawnChunk(new BlockPos((Entity)playerMP), true, this.field_85192_a.field_73011_w.getDimension());
    }

    @Optional.Method(modid="huntingdim")
    private void huntingDimensionPlacement(EntityPlayerMP playerMP, double x, double y, double z) {
        this.protectPlayer(playerMP, new BlockPos(x, y, z));
    }

    public boolean aboveMax(BlockPos pos) {
        boolean flag1 = this.field_85192_a.field_73011_w.getDimension() == -1 && !TeleConfig.pastries.nether.netherCake1x1Logic && (pos.func_177956_o() >= 122 || pos.func_177982_a(0, 1, 0).func_177956_o() >= 122);
        boolean flag2 = this.field_85192_a.func_189509_E(pos);
        return flag1 || flag2;
    }
}

