/*
 * Decompiled with CFR 0.152.
 */
package uk.artdude.zenstages.stager;

import crafttweaker.CraftTweakerAPI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.artdude.zenstages.common.util.Helper;
import uk.artdude.zenstages.stager.Stage;
import uk.artdude.zenstages.stager.type.TypeBase;
import uk.artdude.zenstages.stager.type.TypeDimension;
import uk.artdude.zenstages.stager.type.TypeIngredient;
import uk.artdude.zenstages.stager.type.TypeMob;
import uk.artdude.zenstages.stager.type.TypeMod;
import uk.artdude.zenstages.stager.type.TypeOre;
import uk.artdude.zenstages.stager.type.TypeRecipeName;
import uk.artdude.zenstages.stager.type.TypeTinker;

class DupeChecker {
    private static HashMap<Class<? extends TypeBase>, Map<?, List<String>>> allowedClasses = new HashMap();

    DupeChecker() {
    }

    static void checkForDupes(Map<String, Stage> stageMap) {
        for (Stage currStage : stageMap.values()) {
            for (Stage checkStage : stageMap.values()) {
                if (currStage.getStage().equals(checkStage.getStage())) continue;
                allowedClasses.forEach((clazz, entries) -> Helper.getDuplicates(entries, currStage.getStage(), currStage.filterEntries(clazz), checkStage.filterEntries(clazz)));
            }
        }
    }

    static void logDupes() {
        allowedClasses.forEach((typeClass, typeEntries) -> typeEntries.forEach((value, stages) -> CraftTweakerAPI.logError((String)String.format("[Stage Duplicate] Found a duplicate %s stage for `%s` for stages %s", typeClass.getSimpleName(), value, stages))));
    }

    static {
        allowedClasses.put(TypeDimension.class, new HashMap());
        allowedClasses.put(TypeIngredient.class, new HashMap());
        allowedClasses.put(TypeMob.class, new HashMap());
        allowedClasses.put(TypeMod.class, new HashMap());
        allowedClasses.put(TypeOre.class, new HashMap());
        allowedClasses.put(TypeRecipeName.class, new HashMap());
        allowedClasses.put(TypeTinker.class, new HashMap());
    }
}

