/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.crafting;

import com.blakebr0.cucumber.helper.RecipeHelper;
import com.blakebr0.cucumber.lib.ItemPlaceholder;
import com.blakebr0.ironjetpacks.config.ModConfig;
import com.blakebr0.ironjetpacks.crafting.recipe.JetpackUpgradeRecipe;
import com.blakebr0.ironjetpacks.item.ItemBasic;
import com.blakebr0.ironjetpacks.item.ItemComponent;
import com.blakebr0.ironjetpacks.item.ModItems;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import com.blakebr0.ironjetpacks.registry.JetpackRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="ironjetpacks")
public class ModRecipes {
    @SubscribeEvent
    public static void onRegisterRecipes(RegistryEvent.Register<IRecipe> event) {
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Item)ModItems.STRAP), (Object[])new Object[]{" I ", "LLL", " I ", Character.valueOf('I'), "nuggetIron", Character.valueOf('L'), Items.field_151116_aA});
        RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Item)ModItems.BASIC_COIL), (Object[])new Object[]{"  R", " I ", "R  ", Character.valueOf('R'), "dustRedstone", Character.valueOf('I'), "ingotIron"});
        if (Loader.isModLoaded((String)"thermalfoundation")) {
            ShapedOreRecipe recipe = new ShapedOreRecipe(new ResourceLocation("", ""), new ItemStack((Item)ModItems.ADVANCED_COIL), new Object[]{"R  ", " G ", "  R", Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "ingotGold"}).setMirrored(false);
            recipe.setRegistryName(new ResourceLocation("ironjetpacks", "advanced_coil"));
            event.getRegistry().register((IForgeRegistryEntry)recipe);
        } else {
            RecipeHelper.addShapedRecipe((ItemStack)new ItemStack((Item)ModItems.ADVANCED_COIL), (Object[])new Object[]{"  R", " G ", "R  ", Character.valueOf('R'), "dustRedstone", Character.valueOf('G'), "ingotGold"});
        }
        JetpackRegistry jetpacks = JetpackRegistry.getInstance();
        for (Jetpack jetpack : jetpacks.getAllJetpacks()) {
            ItemPlaceholder mat = jetpack.craftingMaterial;
            ItemComponent thruster = jetpack.thruster;
            ItemComponent capacitor = jetpack.capacitor;
            ItemComponent cell = jetpack.cell;
            ItemBasic strap = ModItems.STRAP;
            int tier = jetpack.tier;
            Item coil = jetpacks.getCoilForTier(tier);
            ShapedOreRecipe jetpackRecipeBasic = null;
            JetpackUpgradeRecipe jetpackRecipeUpgrade = null;
            ShapedOreRecipe thrusterRecipe = null;
            ShapedOreRecipe capacitorRecipe = null;
            ShapedOreRecipe cellRecipe = null;
            boolean forceRecipes = jetpack.forceRecipe;
            if (mat == null) continue;
            if (mat.getValue() instanceof String) {
                if (!OreDictionary.getOres((String)mat.getOreName(), (boolean)false).isEmpty() || forceRecipes) {
                    if (ModConfig.confBasicRecipes) {
                        jetpackRecipeBasic = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "jetpack"), (Item)jetpack.item, new Object[]{"IEI", "IJI", "T T", Character.valueOf('I'), mat.getOreName(), Character.valueOf('T'), thruster, Character.valueOf('E'), capacitor, Character.valueOf('J'), strap});
                    }
                    if (ModConfig.confUpgradeRecipes) {
                        if (tier > jetpacks.getLowestTier()) {
                            jetpackRecipeUpgrade = new JetpackUpgradeRecipe(new ResourceLocation("ironjetpacks", "upgrade"), (Item)jetpack.item, new Object[]{"IEI", "IJI", "T T", Character.valueOf('I'), mat.getOreName(), Character.valueOf('T'), thruster, Character.valueOf('E'), capacitor, Character.valueOf('J'), "jetpackTier" + (tier - 1)});
                        } else if (!ModConfig.confBasicRecipes) {
                            jetpackRecipeBasic = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "jetpack"), (Item)jetpack.item, new Object[]{"IEI", "IJI", "T T", Character.valueOf('I'), mat.getOreName(), Character.valueOf('T'), thruster, Character.valueOf('E'), capacitor, Character.valueOf('J'), strap});
                        }
                    }
                    thrusterRecipe = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "thruster"), (Item)thruster, new Object[]{"ICI", "CEC", "IFI", Character.valueOf('I'), mat.getOreName(), Character.valueOf('C'), coil, Character.valueOf('E'), cell, Character.valueOf('F'), Blocks.field_150460_al});
                    capacitorRecipe = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "capacitor"), (Item)capacitor, new Object[]{"ICI", "ICI", "ICI", Character.valueOf('I'), mat.getOreName(), Character.valueOf('C'), cell});
                    cellRecipe = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "cell"), (Item)cell, new Object[]{" R ", "ICI", " R ", Character.valueOf('I'), mat.getOreName(), Character.valueOf('C'), coil, Character.valueOf('R'), "dustRedstone"});
                }
            } else if (mat.getValue() instanceof ItemStack && (!mat.getStack().func_190926_b() || forceRecipes)) {
                if (ModConfig.confBasicRecipes) {
                    jetpackRecipeBasic = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "jetpack"), (Item)jetpack.item, new Object[]{"IEI", "IJI", "T T", Character.valueOf('I'), mat.getStack(), Character.valueOf('T'), thruster, Character.valueOf('E'), capacitor, Character.valueOf('J'), strap});
                }
                if (ModConfig.confUpgradeRecipes) {
                    if (tier > jetpacks.getLowestTier()) {
                        jetpackRecipeUpgrade = new JetpackUpgradeRecipe(new ResourceLocation("ironjetpacks", "upgrade"), (Item)jetpack.item, new Object[]{"IEI", "IJI", "T T", Character.valueOf('I'), mat.getStack(), Character.valueOf('T'), thruster, Character.valueOf('E'), capacitor, Character.valueOf('J'), "jetpackTier" + (tier - 1)});
                    } else if (!ModConfig.confBasicRecipes) {
                        jetpackRecipeBasic = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "jetpack"), (Item)jetpack.item, new Object[]{"IEI", "IJI", "T T", Character.valueOf('I'), mat.getStack(), Character.valueOf('T'), thruster, Character.valueOf('E'), capacitor, Character.valueOf('J'), strap});
                    }
                }
                thrusterRecipe = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "thruster"), (Item)thruster, new Object[]{"ICI", "CEC", "IFI", Character.valueOf('I'), mat.getStack(), Character.valueOf('C'), coil, Character.valueOf('E'), cell, Character.valueOf('F'), Blocks.field_150460_al});
                capacitorRecipe = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "capacitor"), (Item)capacitor, new Object[]{"ICI", "ICI", "ICI", Character.valueOf('I'), mat.getStack(), Character.valueOf('C'), cell});
                cellRecipe = new ShapedOreRecipe(new ResourceLocation("ironjetpacks", "cell"), (Item)cell, new Object[]{" R ", "ICI", " R ", Character.valueOf('I'), mat.getStack(), Character.valueOf('C'), coil, Character.valueOf('R'), "dustRedstone"});
            }
            if (jetpackRecipeBasic != null) {
                jetpackRecipeBasic.setRegistryName(new ResourceLocation("ironjetpacks", "jetpack_" + jetpack.name));
                event.getRegistry().register(jetpackRecipeBasic);
            }
            if (jetpackRecipeUpgrade != null) {
                jetpackRecipeUpgrade.setRegistryName(new ResourceLocation("ironjetpacks", "upgrade_" + jetpack.name));
                event.getRegistry().register(jetpackRecipeUpgrade);
            }
            if (thrusterRecipe != null) {
                thrusterRecipe.setRegistryName(new ResourceLocation("ironjetpacks", "thruster_" + jetpack.name));
                event.getRegistry().register(thrusterRecipe);
            }
            if (capacitorRecipe != null) {
                capacitorRecipe.setRegistryName(new ResourceLocation("ironjetpacks", "capacitor_" + jetpack.name));
                event.getRegistry().register(capacitorRecipe);
            }
            if (cellRecipe == null) continue;
            cellRecipe.setRegistryName(new ResourceLocation("ironjetpacks", "cell_" + jetpack.name));
            event.getRegistry().register(cellRecipe);
        }
    }
}

