/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.ironjetpacks.item;

import com.blakebr0.cucumber.energy.EnergyCapabilityProvider;
import com.blakebr0.cucumber.energy.EnergyStorageItem;
import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.iface.IColoredItem;
import com.blakebr0.cucumber.iface.IModelHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.ironjetpacks.IronJetpacks;
import com.blakebr0.ironjetpacks.client.model.ModelJetpack;
import com.blakebr0.ironjetpacks.config.ModConfig;
import com.blakebr0.ironjetpacks.handler.InputHandler;
import com.blakebr0.ironjetpacks.lib.Tooltips;
import com.blakebr0.ironjetpacks.registry.Jetpack;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public class ItemJetpack
extends ItemArmor
implements ISpecialArmor,
IModelHelper,
IColoredItem {
    private Jetpack jetpack;
    private ModelBiped model;

    public ItemJetpack(Jetpack jetpack) {
        super(ItemJetpack.makeMaterial(jetpack), 2, EntityEquipmentSlot.CHEST);
        this.func_77655_b("ij.jetpack");
        this.func_77637_a(IronJetpacks.CREATIVE_TAB);
        this.func_77656_e(0);
        this.jetpack = jetpack;
    }

    private static ItemArmor.ArmorMaterial makeMaterial(Jetpack jetpack) {
        return EnumHelper.addArmorMaterial((String)("IJ:" + jetpack.name.toUpperCase(Locale.ROOT)), (String)"ironjetpacks:jetpack", (int)0, (int[])new int[]{0, 0, jetpack.armorPoints, 0}, (int)jetpack.enchantablilty, (SoundEvent)SoundEvents.field_187719_p, (float)0.0f);
    }

    public Jetpack getJetpack() {
        return this.jetpack;
    }

    public IEnergyStorage getEnergyStorage(ItemStack stack) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        }
        return null;
    }

    public boolean isEngineOn(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("Engine")) {
            return tag.func_74767_n("Engine");
        }
        return true;
    }

    public boolean toggleEngine(ItemStack stack) {
        boolean current;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("Engine")) {
            current = tag.func_74767_n("Engine");
        } else {
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            current = true;
        }
        tag.func_74757_a("Engine", !current);
        return !current;
    }

    public boolean isHovering(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("Hover")) {
            return tag.func_74767_n("Hover");
        }
        return false;
    }

    public boolean toggleHover(ItemStack stack) {
        boolean current;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b("Hover")) {
            current = tag.func_74767_n("Hover");
        } else {
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            current = false;
        }
        tag.func_74757_a("Hover", !current);
        return !current;
    }

    public String func_77653_i(ItemStack stack) {
        String name = StringUtils.capitalize((String)this.jetpack.name.replace(" ", "_"));
        return name + " " + Utils.localize((String)(this.func_77658_a() + ".name"));
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ItemJetpack jetpack;
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (!chest.func_190926_b() && chest.func_77973_b() instanceof ItemJetpack && (jetpack = (ItemJetpack)chest.func_77973_b()).isEngineOn(chest)) {
            boolean hover = jetpack.isHovering(chest);
            if (InputHandler.isHoldingUp(player) || hover && !player.field_70122_E) {
                Jetpack info = jetpack.getJetpack();
                double hoverSpeed = InputHandler.isHoldingDown(player) ? info.speedHover : info.speedHoverSlow;
                double currentAccel = info.accelVert * (player.field_70181_x < 0.3 ? 2.5 : 1.0);
                double currentSpeedVertical = info.speedVert * (player.func_70090_H() ? 0.4 : 1.0);
                double usage = player.func_70051_ag() ? (double)info.usage * info.sprintFuel : (double)info.usage;
                boolean creative = info.creative;
                IEnergyStorage energy = jetpack.getEnergyStorage(chest);
                if (!player.field_71075_bZ.field_75098_d && !creative) {
                    energy.extractEnergy((int)usage, false);
                }
                if (energy.getEnergyStored() > 0 || player.field_71075_bZ.field_75098_d || creative) {
                    player.field_70181_x = InputHandler.isHoldingUp(player) ? (!hover ? Math.min(player.field_70181_x + currentAccel, currentSpeedVertical) : (InputHandler.isHoldingDown(player) ? Math.min(player.field_70181_x + currentAccel, -info.speedHoverSlow) : Math.min(player.field_70181_x + currentAccel, info.speedHover))) : Math.min(player.field_70181_x + currentAccel, -hoverSpeed);
                    float speedSideways = (float)(player.func_70093_af() ? info.speedSide * 0.5 : info.speedSide);
                    float speedForward = (float)(player.func_70051_ag() ? (double)speedSideways * info.sprintSpeed : (double)speedSideways);
                    if (InputHandler.isHoldingForwards(player)) {
                        player.func_191958_b(0.0f, 0.0f, speedForward, speedForward);
                    }
                    if (InputHandler.isHoldingBackwards(player)) {
                        player.func_191958_b(0.0f, 0.0f, -speedSideways, speedSideways * 0.8f);
                    }
                    if (InputHandler.isHoldingLeft(player)) {
                        player.func_191958_b(speedSideways, 0.0f, 0.0f, speedSideways);
                    }
                    if (InputHandler.isHoldingRight(player)) {
                        player.func_191958_b(-speedSideways, 0.0f, 0.0f, speedSideways);
                    }
                    if (!world.field_72995_K) {
                        player.field_70143_R = 0.0f;
                        if (player instanceof EntityPlayerMP) {
                            ((EntityPlayerMP)player).field_71135_a.field_147365_f = 0;
                        }
                    }
                }
            }
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return ModConfig.confEnchantableJetpacks && this.jetpack.enchantablilty > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return ModConfig.confEnchantableJetpacks && this.jetpack.enchantablilty > 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (!source.func_76363_c()) {
            int maxAbsorbed;
            int energyPerDamage = this.jetpack.usage;
            IEnergyStorage energy = this.getEnergyStorage(armor);
            int n = maxAbsorbed = energyPerDamage > 0 ? 25 * (energy.getEnergyStored() / energyPerDamage) : 0;
            if (energy.getEnergyStored() < energyPerDamage) {
                return new ISpecialArmor.ArmorProperties(0, 0.65 * ((double)this.jetpack.armorPoints / 20.0), Integer.MAX_VALUE);
            }
            return new ISpecialArmor.ArmorProperties(0, 0.85 * ((double)this.jetpack.armorPoints / 20.0), maxAbsorbed);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        if (!this.jetpack.creative) {
            this.getEnergyStorage(stack).extractEnergy(this.jetpack.usage, false);
        }
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        return this.color();
    }

    public boolean hasOverlay(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage energy = this.getEnergyStorage(stack);
        double stored = energy.getMaxEnergyStored() - energy.getEnergyStored();
        return stored / (double)energy.getMaxEnergyStored();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.jetpack.creative;
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        if (!this.jetpack.creative) {
            IEnergyStorage energy = this.getEnergyStorage(stack);
            tooltip.add(Utils.format((Object)energy.getEnergyStored()) + " / " + Utils.format((Object)energy.getMaxEnergyStored()) + " FE");
        } else {
            tooltip.add(Tooltips.INFINITE.get(new Object[0]) + "\u00a77" + " FE");
        }
        tooltip.add(this.jetpack.rarity.field_77937_e.toString() + Tooltips.TIER.get(this.jetpack.creative ? "C" : Integer.valueOf(this.jetpack.tier)) + "\u00a77" + " - " + Tooltips.ENGINE.get(this.isEngineOn(stack) ? 10 : 12) + "\u00a77" + " - " + Tooltips.HOVER.get(this.isHovering(stack) ? 10 : 12));
        if (ModConfig.confAdvancedInfo) {
            tooltip.add("");
            if (!Utils.isShiftKeyDown()) {
                tooltip.add(Tooltips.HOLD_SHIFT.get(new Object[0]));
            } else {
                tooltip.add(Tooltips.FUEL_USAGE.get(this.jetpack.usage + " FE/t"));
                tooltip.add(Tooltips.VERTICAL_SPEED.get(this.jetpack.speedVert));
                tooltip.add(Tooltips.VERTICAL_ACCELERATION.get(this.jetpack.accelVert));
                tooltip.add(Tooltips.HORIZONTAL_SPEED.get(this.jetpack.speedSide));
                tooltip.add(Tooltips.HOVER_SPEED.get(this.jetpack.speedHoverSlow));
                tooltip.add(Tooltips.DESCEND_SPEED.get(this.jetpack.speedHover));
                tooltip.add(Tooltips.SPRINT_MODIFIER.get(this.jetpack.sprintSpeed));
                tooltip.add(Tooltips.SPRINT_FUEL_MODIFIER.get(this.jetpack.sprintFuel));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this.model == null) {
            this.model = new ModelJetpack(this);
        }
        return this.model;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return type != "overlay" ? "ironjetpacks:textures/armor/jetpack.png" : "ironjetpacks:textures/armor/jetpack_overlay.png";
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.jetpack.rarity;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyCapabilityProvider((IEnergyStorage)new EnergyStorageItem(stack, this.jetpack.capacity));
    }

    public void initModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)ResourceHelper.getModelResource((String)"ironjetpacks", (String)"jetpack", (String)"inventory"));
    }

    public int color() {
        return this.jetpack.color;
    }
}

