/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.ContainerQuantumEntangloporter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiQuantumEntangloporter
extends GuiMekanismTile<TileEntityQuantumEntangloporter> {
    private GuiButton publicButton;
    private GuiButton privateButton;
    private GuiButton setButton;
    private GuiButton deleteButton;
    private GuiButton checkboxButton;
    private GuiScrollList scrollList;
    private GuiTextField frequencyField;
    private boolean privateMode;

    public GuiQuantumEntangloporter(InventoryPlayer inventory, TileEntityQuantumEntangloporter tile) {
        super(tile, new ContainerQuantumEntangloporter(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4);
        this.addGuiElement(this.scrollList);
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab(this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        if (((TileEntityQuantumEntangloporter)this.tileEntity).frequency != null) {
            this.privateMode = !((TileEntityQuantumEntangloporter)this.tileEntity).frequency.publicFreq;
        }
        this.field_147000_g += 64;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.publicButton = new GuiButton(0, this.field_147003_i + 27, this.field_147009_r + 14, 60, 20, LangUtils.localize("gui.public"));
        this.field_146292_n.add(this.publicButton);
        this.privateButton = new GuiButton(1, this.field_147003_i + 89, this.field_147009_r + 14, 60, 20, LangUtils.localize("gui.private"));
        this.field_146292_n.add(this.privateButton);
        this.setButton = new GuiButton(2, this.field_147003_i + 27, this.field_147009_r + 116, 60, 20, LangUtils.localize("gui.set"));
        this.field_146292_n.add(this.setButton);
        this.deleteButton = new GuiButton(3, this.field_147003_i + 89, this.field_147009_r + 116, 60, 20, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        this.frequencyField = new GuiTextField(4, this.field_146289_q, this.field_147003_i + 50, this.field_147009_r + 104, 86, 11);
        this.frequencyField.func_146203_f(16);
        this.frequencyField.func_146185_a(false);
        this.checkboxButton = new GuiButtonDisableableImage(5, this.field_147003_i + 137, this.field_147009_r + 103, 11, 11, this.field_146999_f, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.checkboxButton);
        this.updateButtons();
    }

    public void setFrequency(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        TileNetworkList data = TileNetworkList.withContents(0, freq, !this.privateMode);
        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
    }

    public String getSecurity(Frequency freq) {
        return !freq.publicFreq ? (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.private") : LangUtils.localize("gui.public");
    }

    public void updateButtons() {
        if (((TileEntityQuantumEntangloporter)this.tileEntity).getSecurity().getClientOwner() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : ((TileEntityQuantumEntangloporter)this.tileEntity).privateCache) {
                text.add(freq.name);
            }
        } else {
            for (Frequency freq : ((TileEntityQuantumEntangloporter)this.tileEntity).publicCache) {
                text.add(freq.name + " (" + freq.clientOwner + ")");
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_146124_l = true;
            this.privateButton.field_146124_l = false;
        } else {
            this.publicButton.field_146124_l = false;
            this.privateButton.field_146124_l = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? ((TileEntityQuantumEntangloporter)this.tileEntity).privateCache.get(this.scrollList.getSelection()) : ((TileEntityQuantumEntangloporter)this.tileEntity).publicCache.get(this.scrollList.getSelection());
            this.setButton.field_146124_l = ((TileEntityQuantumEntangloporter)this.tileEntity).getFrequency(null) == null || !((TileEntityQuantumEntangloporter)this.tileEntity).getFrequency(null).equals(freq);
            this.deleteButton.field_146124_l = ((TileEntityQuantumEntangloporter)this.tileEntity).getSecurity().getOwnerUUID().equals(freq.ownerUUID);
        } else {
            this.setButton.field_146124_l = false;
            this.deleteButton.field_146124_l = false;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        this.frequencyField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.updateButtons();
        this.frequencyField.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTeleporter.png");
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.frequencyField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.frequencyField.func_146206_l()) {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
        }
        if (Character.isDigit(c) || Character.isLetter(c) || GuiQuantumEntangloporter.isTextboxKey(c, i) || FrequencyManager.SPECIAL_CHARS.contains(Character.valueOf(c))) {
            this.frequencyField.func_146201_a(c, i);
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.publicButton.field_146127_k) {
            this.privateMode = false;
        } else if (guibutton.field_146127_k == this.privateButton.field_146127_k) {
            this.privateMode = true;
        } else if (guibutton.field_146127_k == this.setButton.field_146127_k) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? ((TileEntityQuantumEntangloporter)this.tileEntity).privateCache.get(selection) : ((TileEntityQuantumEntangloporter)this.tileEntity).publicCache.get(selection);
                this.setFrequency(freq.name);
            }
        } else if (guibutton.field_146127_k == this.deleteButton.field_146127_k) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? ((TileEntityQuantumEntangloporter)this.tileEntity).privateCache.get(selection) : ((TileEntityQuantumEntangloporter)this.tileEntity).publicCache.get(selection);
                TileNetworkList data = TileNetworkList.withContents(1, freq.name, freq.publicFreq);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
                this.scrollList.clearSelection();
            }
        } else if (guibutton.field_146127_k == this.checkboxButton.field_146127_k) {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
        }
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityQuantumEntangloporter)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityQuantumEntangloporter)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.owner") + ": " + (((TileEntityQuantumEntangloporter)this.tileEntity).getSecurity().getClientOwner() != null ? ((TileEntityQuantumEntangloporter)this.tileEntity).getSecurity().getClientOwner() : LangUtils.localize("gui.none")), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.freq") + ":", 32, 81, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.security") + ":", 32, 91, 0x404040);
        Frequency frequency = ((TileEntityQuantumEntangloporter)this.tileEntity).getFrequency(null);
        this.field_146289_q.func_78276_b(" " + (frequency != null ? frequency.name : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.freq") + ":"), 81, 0x797979);
        this.field_146289_q.func_78276_b(" " + (frequency != null ? this.getSecurity(frequency) : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 32 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.security") + ":"), 91, 0x797979);
        String str = LangUtils.localize("gui.set") + ":";
        this.renderScaledText(str, 27, 104, 0x404040, 20);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.frequencyField.func_146194_f();
        MekanismRenderer.resetColor();
    }
}

