/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore;

import java.util.UUID;
import net.minecraft.launchwrapper.Launch;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.config.ConfigurableProperty;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.ConfigurableTypeCategory;
import org.cyclops.cyclopscore.config.extendedconfig.DummyConfig;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tracking.Analytics;
import org.cyclops.cyclopscore.tracking.Versions;

public class GeneralConfig
extends DummyConfig {
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The version at which the config file was generated.", showInGui=false)
    public static String version = "1.6.4";
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="Set 'true' to enable development debug mode. This will result in a lower performance!", requiresMcRestart=true)
    public static boolean debug = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the recipe loader should crash when finding invalid recipes.", requiresMcRestart=true)
    public static boolean crashOnInvalidRecipe = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If mod compatibility loader should crash hard if errors occur in that process.", requiresMcRestart=true)
    public static boolean crashOnModCompatCrash = false;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If an anonymous mod startup analytics request may be sent to our analytics service.")
    public static boolean analytics = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The anonymous id used by the analytics service.")
    public static String anonymousAnalyticsID = UUID.randomUUID().toString();
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="If the version checker should be enabled.")
    public static boolean versionChecker = true;
    @ConfigurableProperty(category=ConfigurableTypeCategory.CORE, comment="The minimum array size of potion types, increase to allow for more potion types.", minimalValue=256, maximalValue=2560, requiresMcRestart=true)
    public static int minimumPotionTypesArraySize = 256;
    @ConfigurableProperty(category=ConfigurableTypeCategory.GENERAL, comment="If a button should be added to the main menu to open a dev world (shift-click creates a new world).")
    public static boolean devWorldButton = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static ConfigurableType TYPE = ConfigurableType.DUMMY;

    public GeneralConfig() {
        super(CyclopsCore._instance, true, "general", null, GeneralConfig.class);
    }

    @Override
    public void onRegistered() {
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_INVALID_RECIPE, crashOnInvalidRecipe);
        this.getMod().putGenericReference(ModBase.REFKEY_DEBUGCONFIG, debug);
        this.getMod().putGenericReference(ModBase.REFKEY_CRASH_ON_MODCOMPAT_CRASH, crashOnModCompatCrash);
        if (analytics) {
            Analytics.registerMod(this.getMod(), "UA-65307010-1");
        }
        if (versionChecker) {
            Versions.registerMod(this.getMod(), CyclopsCore._instance, "https://raw.githubusercontent.com/CyclopsMC/Versions/master/1.12/CyclopsCore.txt");
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

