/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.utility;

import java.util.LinkedHashSet;
import java.util.Set;

public class InheritanceUtil {
    public static Set<Class<?>> getInheritance(Class<?> in) {
        LinkedHashSet result = new LinkedHashSet();
        result.add(in);
        InheritanceUtil.getInheritance(in, result);
        return result;
    }

    private static void getInheritance(Class<?> in, Set<Class<?>> result) {
        Class<?> superclass = InheritanceUtil.getSuperclass(in);
        if (superclass != null) {
            result.add(superclass);
            InheritanceUtil.getInheritance(superclass, result);
        }
        InheritanceUtil.getInterfaceInheritance(in, result);
    }

    private static void getInterfaceInheritance(Class<?> in, Set<Class<?>> result) {
        for (Class<?> c : in.getInterfaces()) {
            result.add(c);
            InheritanceUtil.getInterfaceInheritance(c, result);
        }
    }

    private static Class<?> getSuperclass(Class<?> in) {
        if (in == null) {
            return null;
        }
        if (in.isArray() && in != Object[].class) {
            Class<?> type = in.getComponentType();
            while (type.isArray()) {
                type = type.getComponentType();
            }
            return type;
        }
        return in.getSuperclass();
    }
}

